/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UriParameters {
    private final Map<String, String> _uriParameters = new HashMap<>();

    public void add( String name, String value){
        try{
            _uriParameters.put(name, URLEncoder.encode(value, "UTF-8"));
        }catch (UnsupportedEncodingException ex){
            _uriParameters.put(name, value);
        }
    }

    public String get(String name){
        return _uriParameters.get(name);
    }

    public String get(String name, String defaultValue){
        if(_uriParameters.containsKey(name)){
            return _uriParameters.get(name);
        }else{
            return defaultValue;
        }
    }

    public boolean has(String name){
        return this._uriParameters.containsKey(name);
    }
    
    public Set<Map.Entry<String, String>> getEntrySet(){
        return _uriParameters.entrySet();
    }
}
