/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.users;

import java.util.HashMap;
import java.util.Map;
import net.dreceiptx.users.UserConfigOptionType;
import net.dreceiptx.users.UserIdentifierType;

public class NewUser {
    private String _email;
    private final Map<UserIdentifierType, String> _identifiers = new HashMap<UserIdentifierType, String>();
    private final Map<UserConfigOptionType, String> _config = new HashMap<UserConfigOptionType, String>();
    private boolean _addEmailAsIdentifier = true;

    public NewUser() {
    }

    public NewUser(String email) {
        this.setUserEmail(email);
    }

    public NewUser(String email, boolean _addAsIdentifier) {
        this._addEmailAsIdentifier = _addAsIdentifier;
        this.setUserEmail(email);
    }

    public void setUserEmail(String email) {
        this._email = email;
        if (this._addEmailAsIdentifier) {
            this._identifiers.put(UserIdentifierType.EMAIL, email);
        }
    }

    public void setUserEmail(String email, boolean addAsIdentifier) {
        this._addEmailAsIdentifier = addAsIdentifier;
        this.setUserEmail(email);
    }

    public String getEmail() {
        return this._email;
    }

    public void addIdentifier(UserIdentifierType identifierType, String identifier) {
        this._identifiers.put(identifierType, identifier);
    }

    public Map<UserIdentifierType, String> getIdentifiers() {
        return this._identifiers;
    }

    public void addConfigOption(UserConfigOptionType configOptionType, String optionValue) {
        this._config.put(configOptionType, optionValue);
    }

    public Map<UserConfigOptionType, String> getConfig() {
        return this._config;
    }
}

