/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem.travel;

import java.util.Date;
import net.dreceiptx.receipt.common.GeographicalCoordinates;
import net.dreceiptx.receipt.ecom.AVPType;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;
import net.dreceiptx.receipt.lineitem.travel.GroundTransportType;

public class GroundTransport
extends LineItem {
    public static final String LineItemTypeValue = "TRAVEL0003";

    public GroundTransport(GroundTransportType groundTransportType, String provider, String shortDescription, String longDescription, double price) {
        this(groundTransportType, provider, shortDescription, longDescription, 1, price);
    }

    public GroundTransport(GroundTransportType groundTransportType, String provider, String shortDescription, String longDescription, int quantity, double price) {
        super(provider, shortDescription, longDescription, quantity, price);
        this.setTradeItemGroupIdentificationCode(groundTransportType.code());
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public GroundTransport(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public String getProvider() {
        return this.getBrandName();
    }

    public GroundTransportType getGroundTransportType() {
        return (GroundTransportType)this.getLineItemType(GroundTransportType.class, GroundTransportType.DEFAULT);
    }

    public String getTripDescription() {
        return this.getDescription();
    }

    public void setPassengerName(String passengerName) {
        this._AVPList.add(AVPType.PASSENGER_NAME.Code(), passengerName);
    }

    public String getPassengerName() {
        return this._AVPList.get(AVPType.PASSENGER_NAME.Code()).getValue();
    }

    public void setDriveName(String driverName) {
        this._AVPList.add(AVPType.DRIVER_NAME.Code(), driverName);
    }

    public String getDriverName() {
        return this._AVPList.get(AVPType.DRIVER_NAME.Code()).getValue();
    }

    public void setVehicleIdentifier(String vehicleIdentifier) {
        this._AVPList.add(AVPType.VEHICLE_IDENTIFIER.Code(), vehicleIdentifier);
    }

    public String getVehicleIdentifier() {
        return this._AVPList.get(AVPType.VEHICLE_IDENTIFIER.Code()).getValue();
    }

    public void setTripDistance(Double tripDistance) {
        this._AVPList.add(AVPType.TRIP_DISTANCE.Code(), tripDistance.toString());
    }

    public Double getTripDistance() {
        if (this._AVPList.has(AVPType.TRIP_DISTANCE.Code())) {
            return Double.parseDouble(this._AVPList.get(AVPType.TRIP_DISTANCE.Code()).getValue());
        }
        return null;
    }

    public Date getDepartureDate() {
        return this.getDespatchDate();
    }

    public void setDepartureDate(Date departureDate) {
        this.setDespatchDate(departureDate);
    }

    public Date getArrivalDate() {
        return this.getDeliveryDate();
    }

    public void setArrivalDate(Date arrivalDate) {
        this.setDeliveryDate(arrivalDate);
    }

    public void setBookingNumber(String bookingNumber) {
        this._serialNumber = bookingNumber;
    }

    public String getBookingNumber() {
        return this._serialNumber;
    }

    public void setDepartureGeoLocation(GeographicalCoordinates geographicalCoordinates) {
        this._origin.setGeographicalCoordinates(geographicalCoordinates);
    }

    public GeographicalCoordinates getDepartureGeoLocation() {
        return this._origin.getGeographicalCoordinates();
    }

    public void setArrivalGeoLocation(GeographicalCoordinates geographicalCoordinates) {
        this._destination.setGeographicalCoordinates(geographicalCoordinates);
    }

    public GeographicalCoordinates getArrivalGeoLocation() {
        return this._destination.getGeographicalCoordinates();
    }

    public void setDepartureDetails(Date departureDate, GeographicalCoordinates geographicalCoordinates) {
        this.setDespatchDate(departureDate);
        this.setDepartureGeoLocation(geographicalCoordinates);
    }

    public void setArrivalDetails(Date arrivalDate, GeographicalCoordinates geographicalCoordinates) {
        this.setArrivalDate(arrivalDate);
        this.setArrivalGeoLocation(geographicalCoordinates);
    }
}

