/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.StandardLineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.general.Book;
import net.dreceiptx.receipt.lineitem.travel.Accommodation;
import net.dreceiptx.receipt.lineitem.travel.Flight;
import net.dreceiptx.receipt.lineitem.travel.GroundTransport;

public class LineItemFactory {
    private static Map<String, Class<? extends LineItem>> _lineItems = new HashMap<String, Class<? extends LineItem>>();
    public static final String STANDARD = LineItemFactory.add("STANDARD", StandardLineItem.class);
    public static final String GENERAL0001 = LineItemFactory.add("GENERAL0001", Book.class);
    public static final String TRAVEL0001 = LineItemFactory.add("TRAVEL0001", Accommodation.class);
    public static final String TRAVEL0002 = LineItemFactory.add("TRAVEL0002", Flight.class);
    public static final String TRAVEL0003 = LineItemFactory.add("TRAVEL0003", GroundTransport.class);

    private static String add(String id, Class<? extends LineItem> lineItem) {
        _lineItems.put(id, lineItem);
        return id;
    }

    public LineItem createLineItem(String lineItemCode, TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        if (!_lineItems.containsKey(lineItemCode)) {
            lineItemCode = "STANDARD";
        }
        try {
            Class<? extends LineItem> newLineItemClazz = _lineItems.get(lineItemCode);
            Constructor<? extends LineItem> constructor = newLineItemClazz.getConstructor(TradeItemDescriptionInformation.class, Integer.TYPE, Double.TYPE);
            return constructor.newInstance(tradeItemDescriptionInformation, quantity, price);
        }
        catch (Exception e) {
            return new StandardLineItem(tradeItemDescriptionInformation, quantity, price);
        }
    }
}

