/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.ecom;

import com.google.gson.annotations.SerializedName;

public class AVP {
    @SerializedName("attributeName")
    private String _name = null;
    @SerializedName("qualifierCodeList")
    private String _codeList = null;
    @SerializedName("qualifierCodeListVersion")
    private String _codeListVersion = null;
    @SerializedName("qualifierCodeName")
    private String _codeName = null;
    @SerializedName("value")
    private String _value = null;

    public AVP(String name, String value) {
        _name = name;
        _value = value;
    }

    public String getAttributeName() {
        return _name;
    }

    public void setAttributeName(String name) {
        _name = name;
    }

    public String getCodelist() {
        return _codeList;
    }

    public void setCodelist(String codelist) {
        _codeList = codelist;
    }

    public String getCodelistVersion() {
        return _codeListVersion;
    }

    public void setCodelistVersion(String codelistVersion) {
        _codeListVersion = codelistVersion;
    }

    public String getCodeName() {
        return _codeName;
    }

    public void setCodeName(String codeName) {
        _codeName = codeName;
    }

    public String getValue() {
        return _value;
    }

    public void setValue(String value) {
        _value = value;
    }
}
