/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.merchant;

import com.google.gson.annotations.SerializedName;

public class MerchantContact {
    @SerializedName("contactName") private String _buildingnumber;
    @SerializedName("streetnumber") private String _streetnumber;
    @SerializedName("street") private String _street;
    @SerializedName("street1") private String _street1;
    @SerializedName("street2") private String _street2;
    @SerializedName("street3") private String _street3;
    @SerializedName("city") private String _city;
    @SerializedName("state") private String _state;
    @SerializedName("postcode") private String _postcode;
    @SerializedName("country") private String _country;
    
    public String getBuildingnumber() {
        return _buildingnumber;
    }
    
    public String getStreetnumber() {
        return _streetnumber;
    }
    
    public String getStreet() {
        return _street;
    }
    
    public String getStreet1() {
        return _street1;
    }
    
    public String getStreet2() {
        return _street2;
    }
    
    public String getStreet3() {
        return _street3;
    }
    
    public String getCity() {
        return _city;
    }
    
    public String getState() {
        return _state;
    }
    
    public String getPostcode() {
        return _postcode;
    }
    
    public String getCountry() {
        return _country;
    } 
}
