/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.document;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.dreceiptx.receipt.document.DocumentIdentification;
import net.dreceiptx.receipt.document.DocumentOwner;
import net.dreceiptx.receipt.document.ReceiptContact;
import net.dreceiptx.receipt.validation.ReceiptValidation;

public class StandardBusinessDocumentHeader {
    @SerializedName(value="sender")
    private List<DocumentOwner> _sender = new ArrayList<DocumentOwner>();
    @SerializedName(value="receiver")
    private List<DocumentOwner> _receiver = new ArrayList<DocumentOwner>();
    @SerializedName(value="documentIdentification")
    private DocumentIdentification _documentIdentification = new DocumentIdentification();
    private DocumentOwner _merchant = new DocumentOwner();
    private DocumentOwner _dRx;
    private DocumentOwner _user;

    public StandardBusinessDocumentHeader() {
        this._merchant.getIdentifier().setAuthority("GS1");
        this._merchant.getIdentifier().setValue(null);
        this._sender.add(0, this._merchant);
        this._dRx = new DocumentOwner();
        this._dRx.getIdentifier().setAuthority("GS1");
        this._dRx.getIdentifier().setValue(null);
        this._receiver.add(0, this._dRx);
        this._user = new DocumentOwner();
        this._user.getIdentifier().setAuthority("dRx");
        this._user.getIdentifier().setValue(null);
        this._receiver.add(1, this._user);
    }

    public void setMerchantGLN(String merchantGLN) {
        this._merchant.setValue(merchantGLN);
    }

    public String getMerchantGLN() {
        return this._merchant.getValue();
    }

    public void setdRxGLN(String dRxGLN) {
        this._dRx.setValue(dRxGLN);
    }

    public String getdRxGLN() {
        return this._dRx.getValue();
    }

    public void setUserIdentifier(String userIdentifier) {
        this._user.setValue(userIdentifier);
    }

    public String getUserIdentifier() {
        return this._user.getValue();
    }

    public List<ReceiptContact> getClientContacts() {
        return this._user.getDocumentOwnerContact();
    }

    public void addMerchantContact(ReceiptContact contact) {
        this._merchant.addDocumentOwnerContact(contact);
    }

    public void addRMSContact(ReceiptContact contact) {
        this._user.addDocumentOwnerContact(contact);
    }

    public List<DocumentOwner> getReceiver() {
        return this._receiver;
    }

    public List<DocumentOwner> getSender() {
        return this._sender;
    }

    public void addReceiver(DocumentOwner receiver) {
        this._receiver.add(receiver);
    }

    public DocumentIdentification getDocumentIdentification() {
        return this._documentIdentification;
    }

    public void setDocumentIdentification(DocumentIdentification documentIdentification) {
        this._documentIdentification = documentIdentification;
    }

    public ReceiptValidation validate(ReceiptValidation receiptValidation) {
        if (this._sender.isEmpty()) {
            receiptValidation.AddError("Merchant GLN must be set.");
        }
        return receiptValidation;
    }
}

