/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.dreceiptx.SDK;
import net.dreceiptx.client.ExchangeClient;
import net.dreceiptx.client.UriParameters;
import net.dreceiptx.client.exception.ExchangeClientException;
import net.dreceiptx.config.ConfigManager;
import net.dreceiptx.receipt.DigitalReceipt;
import net.dreceiptx.receipt.DigitalReceiptGenerator;
import net.dreceiptx.receipt.merchant.Merchant;
import net.dreceiptx.receipt.serialization.json.NewUsersSerializer;
import net.dreceiptx.users.NewUser;
import net.dreceiptx.users.NewUserRegistrationResult;
import net.dreceiptx.users.User;
import net.dreceiptx.users.UserIdentifierType;
import net.dreceiptx.users.Users;
import org.apache.commons.codec.binary.Base64;

public class DRXClient
implements ExchangeClient {
    private static final int BUFFER_SIZE = 4096;
    private final ConfigManager _configManager;
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_XML = "application/xml";
    private static final String CONTENT_TYPE_PDF = "application/pdf";
    private String USER_AGENT = "dRx Java SDK/" + SDK.VERSION + " Receipt/" + SDK.RECEIPT_VERSION_COMPATIBILITY;
    private final EnvironmentType _environmentType;
    private String _exchangeProtocol = "https";
    private final String _exchangeHostname;
    private final String _requesterId;
    private final String _receiptVersion;
    private String _directoryProtocol = "https";
    private final String _directoryHostname;
    private final String _userVersion;
    private final String _downloadDirectory;
    private int _responseErrorCode = 500;
    private String _responseErrorMessage = "Unknown Error";

    public DRXClient(ConfigManager configManager) throws ExchangeClientException {
        this._configManager = configManager;
        this._exchangeHostname = this.validateConfigOption("exchange.hostname");
        this._directoryHostname = this.validateConfigOption("directory.hostname");
        this._requesterId = this.validateConfigOption("api.requesterId");
        this._receiptVersion = this.validateConfigOption("receipt.version");
        this._userVersion = this.validateConfigOption("user.version");
        this._downloadDirectory = this.validateConfigOption("download.directory");
        this._environmentType = this._configManager.exists("exchange.protocol") ? EnvironmentType.valueOf(this._configManager.getConfigValue("environment.type")) : EnvironmentType.PROD;
        if (this._configManager.exists("exchange.protocol")) {
            this._exchangeProtocol = this._configManager.getConfigValue("exchange.protocol");
        }
        if (this._configManager.exists("directory.protocol")) {
            this._directoryProtocol = this._configManager.getConfigValue("directory.protocol");
        }
        switch (this._environmentType) {
            case PROD: {
                this._exchangeProtocol = "https";
                this._directoryProtocol = "https";
            }
        }
    }

    @Override
    public User searchUser(UserIdentifierType identifierType, String identifier) throws ExchangeClientException {
        String encodedIdentifier;
        try {
            encodedIdentifier = URLEncoder.encode(identifier, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            encodedIdentifier = identifier;
        }
        UriParameters uriParameters = new UriParameters();
        uriParameters.add("idtype", identifierType.getValue());
        return this.searchUser(encodedIdentifier, uriParameters);
    }

    private User searchUser(String encodedIdentifier, UriParameters uriParameters) throws ExchangeClientException {
        try {
            HttpURLConnection connection = this.createConnection(this._directoryProtocol, this._directoryHostname, "/user/" + encodedIdentifier, CONTENT_TYPE_JSON, "GET", this._userVersion, uriParameters);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == HttpCodes.HTTP_200_OK || responseCode == HttpCodes.HTTP_400_BAD_REQUEST) {
                JsonObject exchangeResponse = this.getResponseJsonObject(connection);
                if (exchangeResponse.get("success").getAsBoolean()) {
                    User user = new User();
                    JsonObject responseData = exchangeResponse.get("responseData").getAsJsonObject();
                    user.setGUID(responseData.get("guid").getAsString());
                    user.setRMS(responseData.get("rms").getAsString());
                    connection.disconnect();
                    return user;
                }
                connection.disconnect();
                throw new ExchangeClientException(exchangeResponse.get("code").getAsInt(), exchangeResponse.get("exceptionMessage").getAsString());
            }
            if (responseCode == HttpCodes.HTTP_404_NOTFOUND) {
                connection.disconnect();
                throw new ExchangeClientException(404, "The exchange host could not be found or is currently unavailable, please check ConfigManager setting and ensure they are correct.");
            }
            if (responseCode == HttpCodes.HTTP_401_UNAUTHORIZED) {
                this.loadErrorResponseJsonObject(connection);
                connection.disconnect();
                throw new ExchangeClientException(this._responseErrorCode, this._responseErrorMessage);
            }
            String errorMessage = connection.getResponseMessage();
            connection.disconnect();
            throw new ExchangeClientException(responseCode, errorMessage);
        }
        catch (SocketTimeoutException te) {
            throw new ExchangeClientException(500, "The connection to the exchange timed out and did not receive a response", te);
        }
        catch (ExchangeClientException dRxE) {
            throw dRxE;
        }
        catch (Exception e) {
            throw new ExchangeClientException(500, e.toString(), e);
        }
    }

    @Override
    public Users searchUsers(UserIdentifierType identifierType, ArrayList<String> userIdentifiers) throws ExchangeClientException {
        UriParameters uriParameters = new UriParameters();
        uriParameters.add("idtype", identifierType.getValue().toLowerCase());
        StringBuilder userIdentifiersParam = new StringBuilder();
        boolean firstIteration = true;
        for (String userIdentifier : userIdentifiers) {
            if (!firstIteration) {
                userIdentifiersParam.append(";");
            }
            userIdentifiersParam.append(userIdentifier);
            firstIteration = false;
        }
        uriParameters.add("identifiers", userIdentifiersParam.toString());
        Users users = new Users();
        try {
            HttpURLConnection connection = this.createConnection(this._directoryProtocol, this._directoryHostname, "/user", CONTENT_TYPE_JSON, "GET", this._userVersion, uriParameters);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == HttpCodes.HTTP_200_OK || responseCode == HttpCodes.HTTP_400_BAD_REQUEST) {
                JsonObject exchangeResponse = this.getResponseJsonObject(connection);
                if (exchangeResponse.get("success").getAsBoolean()) {
                    JsonObject responseData = exchangeResponse.get("responseData").getAsJsonObject();
                    JsonObject userIdentifiersObject = responseData.get("userIdentifiers").getAsJsonObject();
                    for (Map.Entry entry : userIdentifiersObject.entrySet()) {
                        User user;
                        if (!((JsonElement)entry.getValue()).isJsonNull()) {
                            JsonObject userIdentifierObject = userIdentifiersObject.getAsJsonObject((String)entry.getKey());
                            user = new User();
                            user.setIdentifierType(identifierType);
                            user.setIdentifier((String)entry.getKey());
                            user.setGUID(userIdentifierObject.get("guid").getAsString());
                            user.setRMS(userIdentifierObject.get("rms").getAsString());
                        } else {
                            user = new User();
                            user.setIdentifierType(identifierType);
                            user.setIdentifier((String)entry.getKey());
                        }
                        users.add((String)entry.getKey(), user);
                    }
                    connection.disconnect();
                    return users;
                }
                throw new ExchangeClientException(exchangeResponse.get("code").getAsInt(), exchangeResponse.get("exceptionMessage").getAsString());
            }
            if (responseCode == HttpCodes.HTTP_404_NOTFOUND) {
                connection.disconnect();
                throw new ExchangeClientException(404, "The exchange host could not be found or is currently unavailable, please check ConfigManager setting and ensure they are correct.");
            }
            if (responseCode == HttpCodes.HTTP_401_UNAUTHORIZED) {
                this.loadErrorResponseJsonObject(connection);
                connection.disconnect();
                throw new ExchangeClientException(this._responseErrorCode, this._responseErrorMessage);
            }
            String errorMessage = connection.getResponseMessage();
            connection.disconnect();
            throw new ExchangeClientException(responseCode, errorMessage);
        }
        catch (ConnectException ce) {
            throw new ExchangeClientException(500, "There was a connection exception, please ensure internet connectivity and exchange host settings", ce);
        }
        catch (SocketTimeoutException te) {
            throw new ExchangeClientException(500, "The connection to the exchange timed out and did not receive a response", te);
        }
        catch (ExchangeClientException dRxE) {
            throw dRxE;
        }
        catch (Exception e) {
            throw new ExchangeClientException(500, e.toString(), e);
        }
    }

    @Override
    public String sendReceipt(DigitalReceiptGenerator receipt) throws ExchangeClientException {
        try {
            HttpURLConnection connection = this.createConnection(this._exchangeProtocol, this._exchangeHostname, "/receipt", CONTENT_TYPE_JSON, "POST", this._receiptVersion);
            OutputStream os = connection.getOutputStream();
            os.write(receipt.encodeJson().getBytes());
            os.flush();
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == HttpCodes.HTTP_201_CREATED || responseCode == HttpCodes.HTTP_400_BAD_REQUEST) {
                JsonObject exchangeResponse = this.getResponseJsonObject(connection);
                if (exchangeResponse.get("success").getAsBoolean()) {
                    JsonObject responseData = exchangeResponse.get("responseData").getAsJsonObject();
                    return responseData.get("receiptId").getAsString();
                }
                throw new ExchangeClientException(exchangeResponse.get("code").getAsInt(), exchangeResponse.get("exceptionMessage").getAsString());
            }
            if (responseCode == HttpCodes.HTTP_401_UNAUTHORIZED) {
                this.loadErrorResponseJsonObject(connection);
                connection.disconnect();
                throw new ExchangeClientException(this._responseErrorCode, this._responseErrorMessage);
            }
            if (responseCode == HttpCodes.HTTP_404_NOTFOUND) {
                connection.disconnect();
                throw new ExchangeClientException(404, "The exchange host could not be found or is currently unavailable, please check ConfigManager setting and ensure they are correct.");
            }
            String errorMessage = connection.getResponseMessage();
            connection.disconnect();
            throw new ExchangeClientException(responseCode, errorMessage);
        }
        catch (ConnectException ce) {
            throw new ExchangeClientException(500, "There was a connection exception, please ensure internet connectivity and exchange host settings", ce);
        }
        catch (SocketTimeoutException te) {
            throw new ExchangeClientException(500, "The connection to the exchange timed out and did not receive a response", te);
        }
        catch (ExchangeClientException dRxE) {
            throw dRxE;
        }
        catch (Exception e) {
            throw new ExchangeClientException(500, e.toString(), e);
        }
    }

    @Override
    public DigitalReceipt lookupReceipt(String receiptId) throws ExchangeClientException {
        try {
            HttpURLConnection connection = this.createConnection(this._exchangeProtocol, this._exchangeHostname, "/receipt/" + receiptId, CONTENT_TYPE_JSON, "GET", this._receiptVersion);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == HttpCodes.HTTP_200_OK) {
                String response = this.getResponseString(connection);
                connection.disconnect();
                return new DigitalReceipt(response);
            }
            if (responseCode == HttpCodes.HTTP_404_NOTFOUND) {
                connection.disconnect();
                throw new ExchangeClientException(404, "The exchange host could not be found or is currently unavailable, please check ConfigManager setting and ensure they are correct.");
            }
            if (responseCode == HttpCodes.HTTP_400_BAD_REQUEST || responseCode == HttpCodes.HTTP_401_UNAUTHORIZED) {
                this.loadErrorResponseJsonObject(connection);
                connection.disconnect();
                throw new ExchangeClientException(this._responseErrorCode, this._responseErrorMessage);
            }
            String errorMessage = connection.getResponseMessage();
            connection.disconnect();
            throw new ExchangeClientException(responseCode, errorMessage);
        }
        catch (ConnectException ce) {
            throw new ExchangeClientException(500, "There was a connection exception, please ensure internet connectivity and exchange host settings", ce);
        }
        catch (SocketTimeoutException te) {
            throw new ExchangeClientException(500, "The connection to the exchange timed out and did not receive a response", te);
        }
        catch (Exception e) {
            throw new ExchangeClientException(500, e.toString(), e);
        }
    }

    @Override
    public boolean downloadReceiptPDF(String receiptId) throws ExchangeClientException {
        try {
            HttpURLConnection connection = this.createConnection(this._exchangeProtocol, this._exchangeHostname, "/receipt/" + receiptId, CONTENT_TYPE_PDF, "GET", this._receiptVersion);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == HttpCodes.HTTP_200_OK) {
                int bytesRead;
                InputStream pdfInputStream = connection.getInputStream();
                String saveFilePath = this._downloadDirectory + File.separator + receiptId + ".pdf";
                FileOutputStream pdfOutputStream = new FileOutputStream(saveFilePath);
                byte[] buffer = new byte[4096];
                while ((bytesRead = pdfInputStream.read(buffer)) != -1) {
                    pdfOutputStream.write(buffer, 0, bytesRead);
                }
                pdfOutputStream.close();
                pdfInputStream.close();
                return true;
            }
            if (responseCode == HttpCodes.HTTP_404_NOTFOUND) {
                connection.disconnect();
                throw new ExchangeClientException(404, "The exchange host could not be found or is currently unavailable, please check ConfigManager setting and ensure they are correct.");
            }
            if (responseCode == HttpCodes.HTTP_400_BAD_REQUEST || responseCode == HttpCodes.HTTP_401_UNAUTHORIZED) {
                this.loadErrorResponseJsonObject(connection);
                connection.disconnect();
                throw new ExchangeClientException(this._responseErrorCode, this._responseErrorMessage);
            }
            String errorMessage = connection.getResponseMessage();
            connection.disconnect();
            throw new ExchangeClientException(responseCode, errorMessage);
        }
        catch (ConnectException ce) {
            throw new ExchangeClientException(500, "There was a connection exception, please ensure internet connectivity and exchange host settings", ce);
        }
        catch (SocketTimeoutException te) {
            throw new ExchangeClientException(500, "The connection to the exchange timed out and did not receive a response", te);
        }
        catch (ExchangeClientException dRxE) {
            throw dRxE;
        }
        catch (Exception e) {
            throw new ExchangeClientException(500, e.toString(), e);
        }
    }

    @Override
    public NewUserRegistrationResult registerNewUser(NewUser newUser) throws ExchangeClientException {
        ArrayList<NewUser> _newUserCollection = new ArrayList<NewUser>();
        _newUserCollection.add(newUser);
        Map<String, NewUserRegistrationResult> _newUserRegistrationResponse = this.registerNewUser(_newUserCollection);
        return _newUserRegistrationResponse.get(newUser.getEmail());
    }

    @Override
    public Map<String, NewUserRegistrationResult> registerNewUser(List<NewUser> newUsers) throws ExchangeClientException {
        HashMap<String, NewUserRegistrationResult> _newUserRegistrationResponse;
        block13: {
            _newUserRegistrationResponse = new HashMap<String, NewUserRegistrationResult>();
            try {
                Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").registerTypeAdapter(newUsers.getClass(), (Object)new NewUsersSerializer()).create();
                String newUserRegistrationJson = gson.toJson(newUsers);
                HttpURLConnection connection = this.createConnection(this._exchangeProtocol, this._exchangeHostname, "/user", CONTENT_TYPE_JSON, "POST", this._userVersion);
                OutputStream os = connection.getOutputStream();
                os.write(newUserRegistrationJson.getBytes());
                os.flush();
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode == HttpCodes.HTTP_201_CREATED || responseCode == HttpCodes.HTTP_400_BAD_REQUEST) {
                    JsonObject exchangeResponse = this.getResponseJsonObject(connection);
                    if (exchangeResponse.get("success").getAsBoolean()) {
                        JsonObject responseData = exchangeResponse.get("responseData").getAsJsonObject();
                        JsonObject usersObject = responseData.get("users").getAsJsonObject();
                        for (Map.Entry entry : usersObject.entrySet()) {
                            NewUserRegistrationResult newUserRegistrationResult = new NewUserRegistrationResult();
                            if (!((JsonElement)entry.getValue()).isJsonNull()) {
                                JsonObject userRegistrationObject = usersObject.getAsJsonObject((String)entry.getKey());
                                if (userRegistrationObject.get("success").getAsBoolean()) {
                                    newUserRegistrationResult.setUserGUID(userRegistrationObject.get("guid").getAsString());
                                } else {
                                    newUserRegistrationResult.setException(userRegistrationObject.get("code").getAsInt(), userRegistrationObject.get("exception").getAsString());
                                }
                            }
                            _newUserRegistrationResponse.put((String)entry.getKey(), newUserRegistrationResult);
                        }
                        break block13;
                    }
                    throw new ExchangeClientException(exchangeResponse.get("code").getAsInt(), exchangeResponse.get("exceptionMessage").getAsString());
                }
                if (responseCode == HttpCodes.HTTP_401_UNAUTHORIZED) {
                    this.loadErrorResponseJsonObject(connection);
                    connection.disconnect();
                    throw new ExchangeClientException(this._responseErrorCode, this._responseErrorMessage);
                }
                if (responseCode == HttpCodes.HTTP_404_NOTFOUND) {
                    connection.disconnect();
                    throw new ExchangeClientException(this._responseErrorCode, "Exchange could not be found, ensure internet connection or valid URL");
                }
                String errorMessage = connection.getResponseMessage();
                connection.disconnect();
                throw new ExchangeClientException(responseCode, errorMessage);
            }
            catch (ConnectException ce) {
                throw new ExchangeClientException(500, "There was a connection exception, please ensure internet connectivity and exchange host settings", ce);
            }
            catch (SocketTimeoutException te) {
                throw new ExchangeClientException(500, "The connection to the exchange timed out and did not receive a response", te);
            }
            catch (ExchangeClientException dRxE) {
                throw dRxE;
            }
            catch (Exception e) {
                throw new ExchangeClientException(500, e.toString(), e);
            }
        }
        return _newUserRegistrationResponse;
    }

    @Override
    public Merchant lookupMerchant(String Id) throws ExchangeClientException {
        try {
            URL merchantRequest;
            HttpURLConnection connection;
            int responseCode;
            String merchantLocationHostname = "https://cdn.dreceiptx.net/merchant/location/";
            if (!this._environmentType.equals((Object)EnvironmentType.PROD)) {
                merchantLocationHostname = "https://cdn.dreceiptx.net/uat/merchant/location/";
            }
            if ((responseCode = (connection = (HttpURLConnection)(merchantRequest = new URL(merchantLocationHostname + Id + "/info.json")).openConnection()).getResponseCode()) == HttpCodes.HTTP_200_OK) {
                String line;
                BufferedReader merchantRequestConnectionReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = merchantRequestConnectionReader.readLine()) != null) {
                    response.append(line);
                }
                merchantRequestConnectionReader.close();
                Gson gson = new Gson();
                Merchant merchant = (Merchant)gson.fromJson(response.toString(), Merchant.class);
                merchant.setMerchantLocationHostname(merchantLocationHostname);
                return merchant;
            }
            throw new ExchangeClientException(404, "Unknown merchant Id, please supply a valid ");
        }
        catch (ConnectException ce) {
            throw new ExchangeClientException(500, "There was a connection exception, please ensure internet connectivity and exchange host settings", ce);
        }
        catch (SocketTimeoutException te) {
            throw new ExchangeClientException(500, "The connection to the exchange timed out and did not receive a response", te);
        }
        catch (ExchangeClientException dRxE) {
            throw dRxE;
        }
        catch (Exception e) {
            throw new ExchangeClientException(500, e.toString(), e);
        }
    }

    private String createAuthKey(String timestamp) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        String key = this._configManager.getConfigValue("api.key") + ":" + String.valueOf(timestamp) + ":" + this._configManager.getConfigValue("api.requesterId");
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(this._configManager.getConfigValue("api.secret").getBytes(), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        String hash = Base64.encodeBase64String((byte[])sha256_HMAC.doFinal(key.getBytes()));
        return "DRX " + hash;
    }

    private HttpURLConnection createConnection(String protocol, String hostname, String uri, String contentType, String requestMethod, String requestVersion, UriParameters parameters) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        if (parameters != null) {
            StringBuilder parameterString = new StringBuilder();
            boolean firstIteration = true;
            for (Map.Entry<String, String> param : parameters.getEntrySet()) {
                if (firstIteration) {
                    parameterString.append("?");
                    firstIteration = false;
                } else {
                    parameterString.append("&");
                }
                parameterString.append(param.getKey()).append("=").append(param.getValue());
            }
            uri = uri + parameterString.toString();
        }
        URL url = new URL(protocol + "://" + hostname + uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(requestMethod);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        connection.setRequestProperty("Authorization", this.createAuthKey(timestamp));
        connection.setRequestProperty("x-drx-timestamp", timestamp);
        connection.setRequestProperty("x-drx-requester", this._requesterId);
        connection.setRequestProperty("x-drx-version", requestVersion);
        connection.setRequestProperty("User-Agent", this.USER_AGENT);
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(300000);
        return connection;
    }

    private HttpURLConnection createConnection(String protocol, String hostname, String uri, String contentType, String requestMethod, String requestVersion) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        return this.createConnection(protocol, hostname, uri, contentType, requestMethod, requestVersion, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResponseString(HttpURLConnection connection) throws IOException, ExchangeClientException {
        InputStream is = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String result;
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = result = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new ExchangeClientException(500, e.toString(), e);
        }
    }

    private JsonObject getResponseJsonObject(HttpURLConnection connection) throws IOException, ExchangeClientException {
        try {
            JsonParser parser = new JsonParser();
            JsonObject jsonResponse = parser.parse(this.getResponseString(connection)).getAsJsonObject();
            JsonElement element = jsonResponse.get("exchangeResponse");
            return element.getAsJsonObject();
        }
        catch (Exception e) {
            throw new ExchangeClientException(500, "Failed to read Exchange response", e);
        }
    }

    private void loadErrorResponseJsonObject(HttpURLConnection connection) throws ExchangeClientException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            JsonParser parser = new JsonParser();
            JsonObject jsonResponse = parser.parse(sb.toString()).getAsJsonObject();
            JsonObject exchangeResponse = jsonResponse.get("exchangeResponse").getAsJsonObject();
            this._responseErrorCode = exchangeResponse.get("code").getAsInt();
            this._responseErrorMessage = exchangeResponse.get("exceptionMessage").getAsString();
        }
        catch (Exception e) {
            throw new ExchangeClientException(500, "Failed to load Exchange response", e);
        }
    }

    private String validateConfigOption(String configParameter) throws ExchangeClientException {
        if (this._configManager.exists(configParameter)) {
            return this._configManager.getConfigValue(configParameter);
        }
        throw new ExchangeClientException(101, "Required config parameter " + configParameter + " not supplied");
    }

    private static enum EnvironmentType {
        DEV("DEV", "Development or System Test"),
        UAT("UAT", "User acceptance testing or model office"),
        PROD("PROD", "Production/Live environment");

        private String _value;
        private String _displayName;

        private EnvironmentType(String value, String name) {
            this._value = value;
            this._displayName = name;
        }

        public String getValue() {
            return this._value;
        }

        public String getDisplayName() {
            return this._displayName;
        }

        public String toString() {
            return this._displayName;
        }
    }

    private static class HttpCodes {
        private static int HTTP_200_OK = 200;
        private static int HTTP_201_CREATED = 201;
        private static int HTTP_400_BAD_REQUEST = 400;
        private static int HTTP_401_UNAUTHORIZED = 401;
        private static int HTTP_404_NOTFOUND = 404;
        private static int HTTP_501_INTERNAL_SERVER_ERROR = 501;

        private HttpCodes() {
        }
    }
}

