/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.serialization.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.dreceiptx.receipt.common.Amount;
import net.dreceiptx.receipt.common.Currency;
import net.dreceiptx.receipt.invoice.Invoice;

public class InvoiceSerializer
implements JsonSerializer<Invoice> {
    private Currency _invoiceCurrency;

    public InvoiceSerializer(Currency currency) {
        this._invoiceCurrency = currency;
    }

    public JsonElement serialize(Invoice invoice, Type type, JsonSerializationContext jsc) {
        JsonObject tree = (JsonObject)new Gson().toJsonTree((Object)invoice);
        tree.addProperty("creationDateTime", invoice.getCreationDateTimeString());
        JsonObject invoiceIdentification = new JsonObject();
        invoiceIdentification.addProperty("entityIdentification", invoice.getInvoiceIdentification());
        tree.add("invoiceIdentification", (JsonElement)invoiceIdentification);
        if (invoice.getCustomerReference() != null) {
            JsonObject customerReference = new JsonObject();
            customerReference.addProperty("entityIdentification", invoice.getCustomerReference());
            tree.add("customerReference", (JsonElement)customerReference);
        }
        if (invoice.getPurchaseOrder() != null) {
            JsonObject purchaseOrder = new JsonObject();
            purchaseOrder.addProperty("entityIdentification", invoice.getPurchaseOrder());
            tree.add("purchaseOrder", (JsonElement)purchaseOrder);
        }
        JsonObject invoiceTotals = new JsonObject();
        invoiceTotals.add("totalInvoiceAmount", (JsonElement)((JsonObject)new Gson().toJsonTree((Object)new Amount(this._invoiceCurrency, invoice.getSubTotal()))));
        invoiceTotals.add("totalLineAmountInclusiveAllowancesCharges", (JsonElement)((JsonObject)new Gson().toJsonTree((Object)new Amount(this._invoiceCurrency, invoice.getTotal()))));
        invoiceTotals.add("totalTaxAmount", (JsonElement)((JsonObject)new Gson().toJsonTree((Object)new Amount(this._invoiceCurrency, invoice.getTaxesTotal()))));
        tree.add("invoiceTotals", (JsonElement)invoiceTotals);
        tree.add("invoiceLineItem", jsc.serialize(invoice.getInvoiceLineItems()));
        tree.add("invoiceAllowanceCharge", jsc.serialize(invoice.getAllowanceOrCharges()));
        if (invoice.getOriginInformation().gsonValidator()) {
            tree.add("shipFrom", jsc.serialize((Object)invoice.getOriginInformation()));
        }
        if (invoice.getDestinationInformation().gsonValidator()) {
            tree.add("shipTo", jsc.serialize((Object)invoice.getDestinationInformation()));
        }
        if (invoice.getDespatchInformation().gsonValidator()) {
            tree.add("despatchInformation", jsc.serialize((Object)invoice.getDespatchInformation()));
        }
        return tree;
    }
}

