/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem;

import java.util.Date;
import net.dreceiptx.receipt.allowanceCharge.ReceiptAllowanceCharge;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.StandardLineItem;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;
import net.dreceiptx.receipt.tax.Tax;

public class LineItemBuilder {
    private StandardLineItem _lineItem;

    public LineItemBuilder(String brand, String name, String description, int quantity, double price) {
        this._lineItem = new StandardLineItem(brand, name, description, quantity, price);
    }

    public LineItemBuilder(TransactionalTradeItemType type, String code, int quantity, double price) {
        this._lineItem = new StandardLineItem(type, code, quantity, price);
    }

    public LineItemBuilder addTax(Tax tax) {
        this._lineItem.addTax(tax);
        return this;
    }

    public LineItemBuilder addGeneralDiscount(double amount, String description) {
        this._lineItem.addReceiptAllowanceCharges(ReceiptAllowanceCharge.GeneralDiscount(amount, description));
        return this;
    }

    public LineItemBuilder addGeneralDiscount(double amount, String description, Tax tax) {
        this._lineItem.addReceiptAllowanceCharges(ReceiptAllowanceCharge.GeneralDiscount(amount, description, tax));
        return this;
    }

    public LineItemBuilder addPackagingFee(double amount, String description) {
        this._lineItem.addReceiptAllowanceCharges(ReceiptAllowanceCharge.PackagingFee(amount, description));
        return this;
    }

    public LineItemBuilder addPackagingFee(double amount, String description, Tax tax) {
        this._lineItem.addReceiptAllowanceCharges(ReceiptAllowanceCharge.PackagingFee(amount, description, tax));
        return this;
    }

    public LineItemBuilder setSerialNumber(String serialNumber) {
        this._lineItem.setSerialNumber(serialNumber);
        return this;
    }

    public LineItemBuilder setBatchNumber(String batchNumber) {
        this._lineItem.setBatchNumber(batchNumber);
        return this;
    }

    public LineItemBuilder setBillingCostCentre(String billingCostCentre) {
        this._lineItem.setBillingCostCentre(billingCostCentre);
        return this;
    }

    public LineItemBuilder setDespatchDate(Date despatchDate) {
        this._lineItem.setDespatchDate(despatchDate);
        return this;
    }

    public LineItemBuilder setDeliveryDate(Date deliveryDate) {
        this._lineItem.setDeliveryDate(deliveryDate);
        return this;
    }

    public LineItemBuilder setDeliveryInstructions(String deliveryInstructions) {
        this._lineItem.setDeliveryInstructions(deliveryInstructions);
        return this;
    }

    public LineItem create() {
        return this._lineItem;
    }
}

