/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.dreceiptx.client.ExchangeClient;
import net.dreceiptx.client.exception.ExchangeClientException;
import net.dreceiptx.receipt.allowanceCharge.ReceiptAllowanceCharge;
import net.dreceiptx.receipt.common.Address;
import net.dreceiptx.receipt.common.Contact;
import net.dreceiptx.receipt.common.Currency;
import net.dreceiptx.receipt.common.DeliveryInformation;
import net.dreceiptx.receipt.common.GeographicalCoordinates;
import net.dreceiptx.receipt.config.ConfigManager;
import net.dreceiptx.receipt.document.ReceiptContact;
import net.dreceiptx.receipt.document.ReceiptContactType;
import net.dreceiptx.receipt.document.StandardBusinessDocumentHeader;
import net.dreceiptx.receipt.invoice.Invoice;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.StandardLineItem;
import net.dreceiptx.receipt.serialization.json.DigitalReceiptSerializer;
import net.dreceiptx.receipt.serialization.json.InvoiceSerializer;
import net.dreceiptx.receipt.serialization.json.LineItemSerializer;
import net.dreceiptx.receipt.serialization.json.PaymentReceiptsSerializer;
import net.dreceiptx.receipt.settlement.PaymentMethodType;
import net.dreceiptx.receipt.settlement.PaymentReceipt;
import net.dreceiptx.receipt.tax.Tax;
import net.dreceiptx.receipt.tax.TaxCategory;
import net.dreceiptx.receipt.tax.TaxCode;
import net.dreceiptx.receipt.validation.ReceiptValidation;
import net.dreceiptx.users.UserIdentifierType;

public class DigitalReceiptGenerator {
    @SerializedName(value="standardBusinessDocumentHeader")
    private StandardBusinessDocumentHeader _standardBusinessDocumentHeader;
    @SerializedName(value="invoice")
    private Invoice _invoice;
    @SerializedName(value="paymentReceipts")
    private List<PaymentReceipt> _paymentReceipts;
    private static final AtomicInteger _paymentReceiptId = new AtomicInteger(1);
    private final ConfigManager _configManager;
    private ExchangeClient _exchangeClient;
    private String _dRxGLN;
    private String _merchantGLN;
    private String _userGUID;
    private TaxCategory _defaultTaxCategory;
    private TaxCode _defaultTaxCode;
    private Currency _defaultCurrency;
    private String _defaultLanguage;
    private String _defaultTimeZone;
    private String _defaultCountry;

    public DigitalReceiptGenerator(ConfigManager configManager) throws ExchangeClientException {
        this._configManager = configManager;
        this._defaultCountry = this.validateConfigOption("default.country");
        this._defaultLanguage = this.validateConfigOption("default.language");
        this._defaultTimeZone = this.validateConfigOption("default.timezone");
        this._defaultCurrency = Currency.codeOf(this.validateConfigOption("default.currency"));
        this._defaultTaxCategory = Enum.valueOf(TaxCategory.class, this.validateConfigOption("default.taxCategory"));
        this._defaultTaxCode = Enum.valueOf(TaxCode.class, this.validateConfigOption("default.taxCode"));
        this._standardBusinessDocumentHeader = new StandardBusinessDocumentHeader();
        this._standardBusinessDocumentHeader.setdRxGLN(this.validateConfigOption("drx.gln"));
        this._standardBusinessDocumentHeader.setMerchantGLN(this.validateConfigOption("merchant.gln"));
        this._standardBusinessDocumentHeader.getDocumentIdentification().setTypeVersion(this.validateConfigOption("receipt.version"));
        this._standardBusinessDocumentHeader.getDocumentIdentification().setCreationDateAndTime(Calendar.getInstance().getTime());
        this._paymentReceipts = new ArrayList<PaymentReceipt>();
        this._invoice = new Invoice(this._configManager);
    }

    public void setMerchantGLN(String merchantGLN) {
        this._standardBusinessDocumentHeader.setMerchantGLN(merchantGLN);
    }

    public void setUserGUID(UserIdentifierType userIdentifierType, String userIdentifierValue) throws ExchangeClientException {
        this._userGUID = userIdentifierType.getValue() + ":" + userIdentifierValue;
        this._standardBusinessDocumentHeader.setUserIdentifier(this._userGUID);
    }

    public void setMerchantReference(String merchantReference) {
        this._standardBusinessDocumentHeader.getDocumentIdentification().setInstanceIdentifier(merchantReference);
        if (this._invoice.getInvoiceIdentification() == null) {
            this._invoice.setInvoiceIdentification(merchantReference);
        }
    }

    public void setReceiptCurrency(Currency currency) {
        this._defaultCurrency = currency;
    }

    public void setReceiptLanguage(String languageCode) {
        this._defaultLanguage = languageCode;
    }

    public void setReceiptDateTime(Date invoiceDate) {
        this._invoice.setCreationDateTime(invoiceDate);
    }

    public void setPurchaseOrderNumber(String purchaseOrder) {
        this._invoice.setPurchaseOrder(purchaseOrder);
    }

    public void setCustomerReferenceNumber(String customerReference) {
        this._invoice.setCustomerReference(customerReference);
    }

    public void addClientRecipientContact(String name, String email, String phone) {
        this.addRMSContact(ReceiptContactType.RECIPIENT_CONTACT, name, email, phone);
    }

    public void addClientRecipientContact(String name, String email) {
        this.addRMSContact(ReceiptContactType.RECIPIENT_CONTACT, name, email, null);
    }

    public void addClientRecipientContact(String name) {
        this.addRMSContact(ReceiptContactType.RECIPIENT_CONTACT, name, null, null);
    }

    public void addClientPurchasingContact(String name, String email, String phone) {
        this.addRMSContact(ReceiptContactType.PURCHASING_CONTACT, name, email, phone);
    }

    public void addClientPurchasingContact(String name, String email) {
        this.addRMSContact(ReceiptContactType.PURCHASING_CONTACT, name, email, null);
    }

    public void addClientPurchasingContact(String name) {
        this.addRMSContact(ReceiptContactType.PURCHASING_CONTACT, name, null, null);
    }

    private void addRMSContact(ReceiptContactType type, String name, String email, String phone) {
        ReceiptContact rmsContact = new ReceiptContact(type, name);
        if (email != null) {
            rmsContact.addEmailAddress(email);
        }
        if (phone != null) {
            rmsContact.addTelephoneNumber(phone);
        }
        this._standardBusinessDocumentHeader.addRMSContact(rmsContact);
    }

    public void addMerchantCustomerRelationsContact(String name, String email, String phone) {
        this.addMerchantContact(ReceiptContactType.CUSTOMER_RELATIONS, name, email, phone);
    }

    public void addMerchantCustomerRelationsContact(String name, String email) {
        this.addMerchantContact(ReceiptContactType.CUSTOMER_RELATIONS, name, email, null);
    }

    public void addMerchantCustomerRelationsContact(String name) {
        this.addMerchantContact(ReceiptContactType.CUSTOMER_RELATIONS, name, null, null);
    }

    public void addMerchantDeliveryContact(String name, String email, String phone) {
        this.addMerchantContact(ReceiptContactType.DELIVERY_CONTACT, name, email, phone);
    }

    public void addMerchantDeliveryContact(String name, String email) {
        this.addMerchantContact(ReceiptContactType.DELIVERY_CONTACT, name, email, null);
    }

    public void addMerchantDeliveryContact(String name) {
        this.addMerchantContact(ReceiptContactType.DELIVERY_CONTACT, name, null, null);
    }

    public void addMerchantSalesAssistantContact(String name, String email, String phone) {
        this.addMerchantContact(ReceiptContactType.SALES_ADMINISTRATION, name, email, phone);
    }

    public void addMerchantSalesAssistantContact(String name, String email) {
        this.addMerchantContact(ReceiptContactType.SALES_ADMINISTRATION, name, email, null);
    }

    public void addMerchantSalesAssistantContact(String name) {
        this.addMerchantContact(ReceiptContactType.SALES_ADMINISTRATION, name, null, null);
    }

    private void addMerchantContact(ReceiptContactType type, String name, String email, String phone) {
        ReceiptContact merchantContact = new ReceiptContact(type, name);
        if (email != null) {
            merchantContact.addEmailAddress(email);
        }
        if (phone != null) {
            merchantContact.addTelephoneNumber(phone);
        }
        this._standardBusinessDocumentHeader.addMerchantContact(merchantContact);
    }

    public void setReceiptNumber(String receiptNumber) {
        this._invoice.setInvoiceIdentification(receiptNumber);
        if (this._standardBusinessDocumentHeader.getDocumentIdentification().getInstanceIdentifier() == null) {
            this._standardBusinessDocumentHeader.getDocumentIdentification().setInstanceIdentifier(receiptNumber);
        }
    }

    public int addLineItem(LineItem lineItem) {
        for (Tax lineItemTax : lineItem.getTaxes()) {
            this.configureTax(lineItemTax);
        }
        return this._invoice.addLineItem(lineItem);
    }

    public int addLineItem(String brand, String name, Integer quantity, Double price) {
        StandardLineItem lineItem = new StandardLineItem(brand, name, "", quantity, price);
        return this._invoice.addLineItem(lineItem);
    }

    public int addLineItem(String brand, String name, Integer quantity, Double price, Tax tax) {
        StandardLineItem lineItem = new StandardLineItem(brand, name, "", quantity, price);
        lineItem.addTax(this.configureTax(tax));
        return this._invoice.addLineItem(lineItem);
    }

    public int addLineItem(String brand, String name, String description, Integer quantity, Double price) {
        StandardLineItem lineItem = new StandardLineItem(brand, name, description, quantity, price);
        return this._invoice.addLineItem(lineItem);
    }

    public int addLineItem(String brand, String name, String description, Integer quantity, Double price, Tax tax) {
        StandardLineItem lineItem = new StandardLineItem(brand, name, description, quantity, price);
        lineItem.addTax(this.configureTax(tax));
        return this._invoice.addLineItem(lineItem);
    }

    public int addLineItem(String brand, String name, String description, Integer quantity, Double price, Double taxRate, boolean taxInclusive) {
        StandardLineItem lineItem;
        if (taxInclusive) {
            Double netPrice = price * (1.0 - taxRate);
            Double total = (double)quantity.intValue() * netPrice;
            Tax tax = new Tax(this._defaultTaxCategory, this._defaultTaxCode, total, taxRate);
            lineItem = new StandardLineItem(brand, name, description, quantity, price);
            lineItem.addTax(tax);
        } else {
            Double netPrice = price;
            Double total = (double)quantity.intValue() * netPrice;
            Tax tax = new Tax(this._defaultTaxCategory, this._defaultTaxCode, total, taxRate);
            lineItem = new StandardLineItem(brand, name, description, quantity, price);
            lineItem.addTax(tax);
        }
        return this._invoice.addLineItem(lineItem);
    }

    public int addPaymentReceipt(PaymentMethodType paymentMethodCode, Double paymentAmount) {
        PaymentReceipt paymentReceipt = new PaymentReceipt(paymentMethodCode, paymentAmount);
        paymentReceipt.setSettlementCurrency(this._defaultCurrency);
        paymentReceipt.setId(_paymentReceiptId.getAndIncrement());
        this._paymentReceipts.add(paymentReceipt);
        return paymentReceipt.getId();
    }

    public int addPaymentReceipt(PaymentReceipt paymentReceipt) {
        paymentReceipt.setId(_paymentReceiptId.getAndIncrement());
        paymentReceipt.setSettlementCurrency(this._defaultCurrency);
        this._paymentReceipts.add(paymentReceipt);
        return paymentReceipt.getId();
    }

    public void removePaymentReceipt(int paymentId) {
        PaymentReceipt item = null;
        for (PaymentReceipt paymentReceipt : this._paymentReceipts) {
            if (paymentReceipt.getId() != paymentId) continue;
            item = paymentReceipt;
            break;
        }
        if (item != null) {
            this._paymentReceipts.remove(item);
        }
    }

    public void addGeneralDiscount(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.GeneralDiscount(amount, description));
    }

    public void addGeneralDiscount(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.GeneralDiscount(amount, description, this.configureTax(tax)));
    }

    public void addTip(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.Tip(amount, description));
    }

    public void addTip(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.Tip(amount, description, this.configureTax(tax)));
    }

    public void addPackagingFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.PackagingFee(amount, description));
    }

    public void addPackagingFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.PackagingFee(amount, description, this.configureTax(tax)));
    }

    public void addDeliveryFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.DeliveryFee(amount, description));
    }

    public void addDeliveryFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.DeliveryFee(amount, description, this.configureTax(tax)));
    }

    public void addFrieghtFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.FreightFee(amount, description));
    }

    public void addFrieghtFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.FreightFee(amount, description, this.configureTax(tax)));
    }

    public void addProcessingFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.ProcessingFee(amount, description));
    }

    public void addProcessingFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.ProcessingFee(amount, description, this.configureTax(tax)));
    }

    public void addBookingFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.BookingFee(amount, description));
    }

    public void addBookingFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.BookingFee(amount, description, this.configureTax(tax)));
    }

    public void setDeliveryInformation(DeliveryInformation deliveryInformation) {
        this._invoice.setDestinationInformation(deliveryInformation.getLocationInformation());
        this._invoice.getAllowanceOrCharges().addAll(deliveryInformation.getDeliveryFees());
        this._invoice.setDespatchInformation(deliveryInformation.getDespatchInformation());
    }

    public void setDeliveryAddress(Address address) {
        this._invoice.getDestinationInformation().setAddress(address);
    }

    public void setDeliveryAddress(Address address, Contact contact) {
        this._invoice.getDestinationInformation().setAddress(address);
        this._invoice.getDestinationInformation().addContact(contact);
    }

    public void setDestinationCoordinates(GeographicalCoordinates geographicalCoordinates) {
        this._invoice.getDestinationInformation().setGeographicalCoordinates(geographicalCoordinates);
    }

    public void setDeliveryDate(Date deliverDate) {
        this._invoice.getDespatchInformation().setDeliveryDate(deliverDate);
    }

    public void setOriginAddress(Address address) {
        this._invoice.getOriginInformation().setAddress(address);
    }

    public void setOriginAddress(Address address, Contact contact) {
        this._invoice.getOriginInformation().setAddress(address);
        this._invoice.getOriginInformation().addContact(contact);
    }

    public void setOriginCoordinates(GeographicalCoordinates geographicalCoordinates) {
        this._invoice.getOriginInformation().setGeographicalCoordinates(geographicalCoordinates);
    }

    public void validate() {
        ReceiptValidation receiptValidation = new ReceiptValidation();
        this._standardBusinessDocumentHeader.validate(receiptValidation);
        this._invoice.validate(receiptValidation);
    }

    private Tax configureTax(Tax tax) {
        if (tax.getTaxCategory() == null) {
            tax.setTaxCategory(this._defaultTaxCategory);
        }
        if (tax.getTaxCode() == null) {
            tax.setTaxCode(this._defaultTaxCode);
        }
        return tax;
    }

    public String encodeJson() {
        DigitalReceiptSerializer digitalReceiptMapper = new DigitalReceiptSerializer();
        digitalReceiptMapper.setInvoice(this._invoice);
        digitalReceiptMapper.setStandardBusinessDocumentHeader(this._standardBusinessDocumentHeader);
        digitalReceiptMapper.setPaymentReceipts(this._paymentReceipts);
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").registerTypeAdapter(Invoice.class, (Object)new InvoiceSerializer(this._defaultCurrency)).registerTypeHierarchyAdapter(LineItem.class, (Object)new LineItemSerializer(this._defaultCurrency)).registerTypeAdapter(new TypeToken<List<PaymentReceipt>>(){}.getType(), (Object)new PaymentReceiptsSerializer(this._dRxGLN, this._merchantGLN, this._userGUID)).create();
        String digitalReceiptJson = gson.toJson((Object)digitalReceiptMapper);
        return digitalReceiptJson;
    }

    private String validateConfigOption(String configParameter) throws ExchangeClientException {
        if (this._configManager.exists(configParameter)) {
            return this._configManager.getConfigValue(configParameter);
        }
        throw new ExchangeClientException(101, "Required config parameter " + configParameter + " not supplied");
    }
}

