/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.merchant;

import com.google.gson.annotations.SerializedName;
import java.util.List;

public class Merchant {
    private String _id;
    @SerializedName("industry") private String _industry;
    @SerializedName("sector") private String _sector;
    @SerializedName("fullName") private String _fullname;
    @SerializedName("commonName") private String _commonName;
    @SerializedName("businessTaxNumber") private String _businessTaxNumber;
    @SerializedName("businessRegistrationNumber") private String _businessRegistrationNumber;
    @SerializedName("primaryPhone") private String _primaryPhone;
    @SerializedName("primaryAddress") private MerchantAddress _primaryAddress;
    @SerializedName("contacts") private List<MerchantContact> _contacts;
    private transient String _merchantLocationHostname = "https://cdn.dreceiptx.net/merchant/location/";
    
    public String getIndustry() {
        return _industry;
    }
    
    public String getSector(){
        return _sector;
    }
    
    public String getLocationId(){
        return _id;
    }
    
    public String getFullName() {
        return _fullname;
    }
    
    public String getCommonName() {
        return _commonName;
    }
    
    public String getBusinessTaxNumber() {
        return _businessTaxNumber;
    }
    
    public String getBusinessRegistrationNumber() {
        return _businessRegistrationNumber;
    }
    
    public String getPrimaryPhone() {
        return _primaryPhone;
    }
    
    public MerchantAddress getPrimaryAddress() {
        return _primaryAddress;
    }
    
    public List<MerchantContact> getContacts() {
        return _contacts;
    }
    
    public String getMerchantLogoUrl(){
        return _merchantLocationHostname+_id+"/logo.jpg";
    }
    
    public void setMerchantLocationHostname(String merchantLocationHostname){
        _merchantLocationHostname = merchantLocationHostname;
    }

}
