/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.serialization.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import net.dreceiptx.receipt.common.Currency;
import net.dreceiptx.receipt.ecom.AVP;
import net.dreceiptx.receipt.lineitem.LineItem;

public class LineItemSerializer
implements JsonSerializer<LineItem> {
    private Currency _lineItemCurrency;

    public LineItemSerializer(Currency currency) {
        this._lineItemCurrency = currency;
    }

    public JsonElement serialize(LineItem lineitem, Type type, JsonSerializationContext jsc) {
        JsonObject tree = (JsonObject)new Gson().toJsonTree((Object)lineitem);
        tree.addProperty("lineItemNumber", (Number)lineitem.getLineItemId());
        tree.addProperty("creditLineIndicator", Boolean.valueOf(lineitem.isReturnOrExchange()));
        tree.addProperty("invoicedQuantity", (Number)lineitem.getQuantity());
        tree.addProperty("itemPriceExclusiveAllowancesCharges", (Number)lineitem.getPrice());
        tree.addProperty("amountInclusiveAllowancesCharges", (Number)lineitem.getNetTotal());
        tree.addProperty("amountExclusiveAllowancesCharges", (Number)lineitem.getSubTotal());
        if (lineitem.getBillingCostCentre() != null) {
            JsonObject billingCostCentre = new JsonObject();
            billingCostCentre.addProperty("entityIdentification", lineitem.getBillingCostCentre());
            tree.add("billingCostCentre", (JsonElement)billingCostCentre);
        }
        JsonObject transactionalTradeItem = new JsonObject();
        transactionalTradeItem.add("tradeItemDescriptionInformation", jsc.serialize((Object)lineitem.getTradeItemDescriptionInformation()));
        switch (lineitem.getTransactionalTradeItemType()) {
            case GTIN: {
                transactionalTradeItem.addProperty("gtin", lineitem.getTransactionalTradeItemCode());
                break;
            }
        }
        JsonArray additionalTradeItemIdentification = new JsonArray();
        for (Map.Entry<String, String> tradeItemIdentification : lineitem.getTradeItemIdentification().getEntrySet()) {
            JsonObject tradeItemIdentificationObject = new JsonObject();
            tradeItemIdentificationObject.addProperty("additionalTradeItemIdentificationType", tradeItemIdentification.getKey());
            tradeItemIdentificationObject.addProperty("additionalTradeItemIdentificationValue", tradeItemIdentification.getValue());
            additionalTradeItemIdentification.add((JsonElement)tradeItemIdentificationObject);
        }
        if (additionalTradeItemIdentification.size() != 0) {
            transactionalTradeItem.add("additionalTradeItemIdentification", (JsonElement)additionalTradeItemIdentification);
        }
        JsonObject transactionalItemData = new JsonObject();
        if (lineitem.getSerialNumber() != null) {
            transactionalItemData.addProperty("serialNumber", lineitem.getSerialNumber());
        }
        if (lineitem.getBatchNumber() != null) {
            transactionalItemData.addProperty("batchNumber", lineitem.getBatchNumber());
        }
        if (!transactionalItemData.entrySet().isEmpty()) {
            transactionalTradeItem.add("transactionalItemData", (JsonElement)transactionalItemData);
        }
        tree.add("transactionalTradeItem", jsc.serialize((Object)transactionalTradeItem));
        if (lineitem.hasTaxes()) {
            tree.add("invoiceLineTaxInformation", jsc.serialize(lineitem.getTaxes()));
        }
        if (lineitem.getOriginInformation().gsonValidator()) {
            tree.add("shipFrom", jsc.serialize((Object)lineitem.getOriginInformation()));
        }
        if (lineitem.getDestinationInformation().gsonValidator()) {
            tree.add("shipTo", jsc.serialize((Object)lineitem.getDestinationInformation()));
        }
        if (lineitem.getDespatchInformation().gsonValidator()) {
            tree.add("despatchInformation", jsc.serialize((Object)lineitem.getDespatchInformation()));
        }
        JsonArray avpList = new JsonArray();
        for (Map.Entry<String, AVP> avp : lineitem.getEcomAVPList().getEntrySet()) {
            avpList.add(jsc.serialize((Object)avp.getValue()));
        }
        if (avpList.size() != 0) {
            tree.add("avpList", (JsonElement)avpList);
        }
        tree.add("invoiceAllowanceCharge", jsc.serialize(lineitem.getReceiptAllowanceCharges()));
        return tree;
    }
}

