/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem.travel;

import java.util.Date;
import net.dreceiptx.receipt.common.GeographicalCoordinates;
import net.dreceiptx.receipt.ecom.AVPType;
import net.dreceiptx.receipt.invoice.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.LineItem;

public class Taxi
extends LineItem {
    public static final String LineItemTypeValue = "TRAVEL_TAXI";

    public Taxi(String provider, String tripDetail, String tripDescription, int quantity, double price) {
        super(provider, tripDetail, tripDescription, quantity, price);
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public Taxi(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public String getTaxiProvider() {
        return this.getBrandName();
    }

    public String getTripDetail() {
        return this.getName();
    }

    public String getTripDescription() {
        return this.getDescription();
    }

    public void setPassengerName(String passengerName) {
        this._AVPList.add(AVPType.PASSENGER_NAME.Code(), passengerName);
    }

    public String getPassengerName() {
        return this._AVPList.get(AVPType.PASSENGER_NAME.Code()).getValue();
    }

    public void setDriveName(String driverName) {
        this._AVPList.add(AVPType.DRIVER_NAME.Code(), driverName);
    }

    public String getDriverName() {
        return this._AVPList.get(AVPType.DRIVER_NAME.Code()).getValue();
    }

    public void setTaxiIdentfier(String driverName) {
        this._AVPList.add(AVPType.VEHICLE_IDENTIFIER.Code(), driverName);
    }

    public String getTaxiIdentfier() {
        return this._AVPList.get(AVPType.VEHICLE_IDENTIFIER.Code()).getValue();
    }

    public void setTripDistance(Double tripDistance) {
        this._AVPList.add(AVPType.TRIP_DISTANCE.Code(), tripDistance.toString());
    }

    public Double getTripDistance() {
        if (this._AVPList.has(AVPType.TRIP_DISTANCE.Code())) {
            return Double.parseDouble(this._AVPList.get(AVPType.TRIP_DISTANCE.Code()).getValue());
        }
        return null;
    }

    public Date getDepartureDate() {
        return this.getDespatchDate();
    }

    public void setDepartureDate(Date departureDate) {
        this.setDespatchDate(departureDate);
    }

    public Date getArrivalDate() {
        return this.getDeliveryDate();
    }

    public void setArrivalDate(Date arrivalDate) {
        this.setDeliveryDate(arrivalDate);
    }

    public void setBookingNumber(String bookingNumber) {
        this._serialNumber = bookingNumber;
    }

    public String getBookingNumber() {
        return this._serialNumber;
    }

    public void setDepartureGeoLocation(GeographicalCoordinates geographicalCoordinates) {
        this._origin.setGeographicalCoordinates(geographicalCoordinates);
    }

    public GeographicalCoordinates getDepartureGeoLocation() {
        return this._origin.getGeographicalCoordinates();
    }

    public void setArrivalGeoLocation(GeographicalCoordinates geographicalCoordinates) {
        this._destination.setGeographicalCoordinates(geographicalCoordinates);
    }

    public GeographicalCoordinates getArrivalGeoLocation() {
        return this._destination.getGeographicalCoordinates();
    }

    public void setDepartureDetails(Date departureDate, GeographicalCoordinates geographicalCoordinates) {
        this.setDespatchDate(departureDate);
        this._origin.setGeographicalCoordinates(geographicalCoordinates);
    }

    public void setArrivalDetails(Date arrivalDate, GeographicalCoordinates geographicalCoordinates) {
        this.setArrivalDate(arrivalDate);
        this._destination.setGeographicalCoordinates(geographicalCoordinates);
    }
}

