/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.tax;

import com.google.gson.annotations.SerializedName;
import net.dreceiptx.receipt.tax.TaxCategory;
import net.dreceiptx.receipt.tax.TaxCode;

public class Tax {
    @SerializedName(value="dutyFeeTaxCategoryCode")
    private TaxCategory _category = null;
    @SerializedName(value="dutyFeeTaxTypeCode")
    private TaxCode _code = null;
    @SerializedName(value="dutyFeeTaxBasisAmount")
    private double _taxableAmount;
    @SerializedName(value="dutyFeeTaxPercentage")
    private double _rate;
    @SerializedName(value="dutyFeeTaxAmount")
    private double _totalTax;

    public Tax(double taxableAmount, double totalTax) {
        this._taxableAmount = taxableAmount;
        this._totalTax = totalTax;
        this._rate = this._totalTax / this._taxableAmount * 100.0;
    }

    public Tax(TaxCategory category, TaxCode code, double taxableAmount, double totalTax) {
        this._category = category;
        this._code = code;
        this._taxableAmount = taxableAmount;
        this._totalTax = totalTax;
        this._rate = this._totalTax / this._taxableAmount * 100.0;
    }

    public void setTaxCategory(TaxCategory taxCategory) {
        this._category = taxCategory;
    }

    public void setTaxCode(TaxCode taxCode) {
        this._code = taxCode;
    }

    public double getTaxRate() {
        return this._rate;
    }

    public double getTaxableAmount() {
        return this._taxableAmount;
    }

    public double getTaxTotal() {
        return this._totalTax;
    }

    public void setTaxTotal(double taxTotal) {
        this._totalTax = taxTotal;
    }

    public TaxCategory getTaxCategory() {
        return this._category;
    }

    public TaxCode getTaxCode() {
        return this._code;
    }

    public Boolean is(TaxCode taxCode) {
        return taxCode == this._code;
    }
}

