/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.serialization.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.dreceiptx.receipt.common.Amount;
import net.dreceiptx.receipt.common.Currency;
import net.dreceiptx.receipt.settlement.PaymentMethodType;
import net.dreceiptx.receipt.settlement.PaymentReceipt;

public class PaymentReceiptsSerializer
implements JsonSerializer<List<PaymentReceipt>> {
    private final String _dRxGLN;
    private final String _merchantId;
    private final String _userGuid;

    public PaymentReceiptsSerializer(String dRxGLN, String merchantId, String userGuid) {
        this._dRxGLN = dRxGLN;
        this._merchantId = merchantId;
        this._userGuid = userGuid;
    }

    public JsonElement serialize(List<PaymentReceipt> paymentReceipts, Type type, JsonSerializationContext jsc) {
        JsonArray tree = new JsonArray();
        for (PaymentMethodType paymentMethodType : PaymentMethodType.values()) {
            ArrayList<Currency> loadedCurrencies = new ArrayList<Currency>();
            for (PaymentReceipt paymentReceiptOuter : paymentReceipts) {
                if (!paymentReceiptOuter.getPaymentMethodType().equals((Object)paymentMethodType) || loadedCurrencies.contains((Object)paymentReceiptOuter.getSettlementCurrency())) continue;
                JsonArray settlementLineItems = new JsonArray();
                Double settlementLineItemsTotal = 0.0;
                for (PaymentReceipt paymentReceiptInner : paymentReceipts) {
                    if (!paymentReceiptInner.getSettlementCurrency().equals((Object)paymentReceiptOuter.getSettlementCurrency())) continue;
                    JsonObject settlementLineItem = new JsonObject();
                    settlementLineItem.addProperty("lineItemNumber", (Number)paymentReceiptInner.getId());
                    settlementLineItem.add("amountPaid", (JsonElement)((JsonObject)new Gson().toJsonTree((Object)new Amount(paymentReceiptInner.getPaymentAmount(), paymentReceiptOuter.getSettlementCurrency()))));
                    if (paymentReceiptInner.hasPaymentAuthorisation().booleanValue()) {
                        JsonObject settlementParty = new JsonObject();
                        settlementParty.addProperty("partyRoleCode", "CENTRAL_PAYMENT_SERVICE");
                        settlementParty.addProperty("value", paymentReceiptInner.getPaymentAuthorisation().getPaymentProvider());
                        settlementLineItem.add("settlementParty", (JsonElement)settlementParty);
                        JsonArray transactionalReference = new JsonArray();
                        JsonObject authorisationNumber = new JsonObject();
                        authorisationNumber.addProperty("transactionalReferenceTypeCode", "ANJ");
                        authorisationNumber.addProperty("entityIdentification", paymentReceiptInner.getPaymentAuthorisation().getAuthorisationNumber());
                        JsonObject authorisationCode = new JsonObject();
                        authorisationCode.addProperty("transactionalReferenceTypeCode", "AKO");
                        authorisationCode.addProperty("entityIdentification", paymentReceiptInner.getPaymentAuthorisation().getAuthorisationNumber());
                        transactionalReference.add((JsonElement)authorisationNumber);
                        transactionalReference.add((JsonElement)authorisationCode);
                        settlementLineItem.add("transactionalReference", (JsonElement)transactionalReference);
                    }
                    settlementLineItems.add((JsonElement)settlementLineItem);
                    settlementLineItemsTotal = paymentReceiptInner.getPaymentAmount();
                }
                JsonObject paymentReceiptObject = new JsonObject();
                paymentReceiptObject.addProperty("settlementCurrency", paymentReceiptOuter.getSettlementCurrency().getValue());
                paymentReceiptObject.addProperty("settlementIdentification", paymentMethodType.getValue());
                paymentReceiptObject.addProperty("totalAmount", (Number)settlementLineItemsTotal);
                JsonObject paymentMethod = new JsonObject();
                paymentMethod.addProperty("paymentMethodCode", paymentMethodType.getValue());
                paymentReceiptObject.add("paymentMethod", (JsonElement)paymentMethod);
                paymentReceiptObject.addProperty("totalAmount", (Number)settlementLineItemsTotal);
                paymentReceiptObject.addProperty("settlementHandlingTypeCode", "REMITTANCE_ONLY");
                JsonObject payee = new JsonObject();
                payee.addProperty("gln", this._merchantId);
                paymentReceiptObject.add("payee", (JsonElement)payee);
                JsonObject payer = new JsonObject();
                payer.addProperty("gln", this._dRxGLN);
                JsonObject additionalPartyIdentification = new JsonObject();
                additionalPartyIdentification.addProperty("Authority", "dRX");
                additionalPartyIdentification.addProperty("value", this._userGuid);
                payer.add("additionalPartyIdentification", (JsonElement)additionalPartyIdentification);
                paymentReceiptObject.add("payer", (JsonElement)payer);
                paymentReceiptObject.add("settlementLineItem", (JsonElement)settlementLineItems);
                tree.add((JsonElement)paymentReceiptObject);
                loadedCurrencies.add(paymentReceiptOuter.getSettlementCurrency());
            }
        }
        return tree;
    }
}

