/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem.travel;

import java.util.Date;
import net.dreceiptx.receipt.invoice.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.LineItem;

public class Flight
extends LineItem {
    public static final String LineItemTypeValue = "TRAVEL_FLIGHT";
    private static final String _tradeItemIdentificationPassenger = "PASSENGER_NAME";

    public Flight(String airline, String itinerary, String itineraryDescription, int quantity, double price) {
        super(airline, itinerary, itineraryDescription, quantity, price);
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public Flight(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public String getAirline() {
        return this.getBrandName();
    }

    public String getItinerary() {
        return this.getName();
    }

    public String getItineraryDescription() {
        return this.getDescription();
    }

    public void setPassengerName(String passengerName) {
        this.addTradeItemIdentification(_tradeItemIdentificationPassenger, passengerName);
    }

    public String getPassengerName() {
        return this.getTradeItemIdentificationValue(_tradeItemIdentificationPassenger);
    }

    public Date getDepartureDate() {
        return this.getDespatchDate();
    }

    public void setDepartureDate(Date departureDate) {
        this.setDespatchDate(departureDate);
    }

    public void setTicketNumber(String ticketNumber) {
        this._serialNumber = ticketNumber;
    }

    public String getTicketNumber() {
        return this._serialNumber;
    }
}

