/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.dreceiptx.receipt.invoice.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.StandardLineItem;
import net.dreceiptx.receipt.lineitem.general.Book;
import net.dreceiptx.receipt.lineitem.travel.Flight;

public class LineItemFactory {
    private static Map<String, Class<? extends LineItem>> _lineItems = new HashMap<String, Class<? extends LineItem>>();
    public static final String STANDARD_LINEITEM = LineItemFactory.add("STANDARD_LINEITEM", StandardLineItem.class);
    public static final String GENERAL_BOOK = LineItemFactory.add("GENERAL_BOOK", Book.class);
    public static final String TRAVEL_FLIGHT = LineItemFactory.add("TRAVEL_FLIGHT", Flight.class);

    private static String add(String id, Class<? extends LineItem> lineItem) {
        _lineItems.put(id, lineItem);
        return id;
    }

    public LineItem createLineItem(String lineItemCode, TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        if (!_lineItems.containsKey(lineItemCode)) {
            lineItemCode = "STANDARD_LINEITEM";
        }
        try {
            Class<? extends LineItem> newLineItemClazz = _lineItems.get(lineItemCode);
            Constructor<? extends LineItem> constructor = newLineItemClazz.getConstructor(TradeItemDescriptionInformation.class, Integer.TYPE, Double.TYPE);
            return constructor.newInstance(tradeItemDescriptionInformation, quantity, price);
        }
        catch (Exception e) {
            return new StandardLineItem(tradeItemDescriptionInformation, quantity, price);
        }
    }
}

