/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import net.dreceiptx.receipt.config.ConfigManager;

public class PropertiesConfigManager
implements ConfigManager {
    private Properties _properties;
    private final String _configFile;
    private static final String _defaultConfigFile = "./src/main/resources/config/drx.properties";

    public PropertiesConfigManager() {
        this(_defaultConfigFile);
    }

    public PropertiesConfigManager(String configFileLocation) {
        this._configFile = configFileLocation;
        this._properties = this.getdRxConfig();
    }

    @Override
    public String getConfigValue(String key) {
        return this._properties.getProperty(key);
    }

    @Override
    public boolean exists(String key) {
        return this._properties.containsKey(key);
    }

    private Properties getdRxConfig() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(this._configFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    @Override
    public void setConfigValue(String key, String value) {
        this._properties.setProperty(key, value);
    }

    @Override
    public void setConfigValue(String key, String value, Boolean commit) {
        this.setConfigValue(key, value);
        if (commit.booleanValue()) {
            try {
                URL url = PropertiesConfigManager.class.getResource(this._configFile);
                this._properties.store(new FileOutputStream(new File(url.toURI())), null);
            }
            catch (IOException e) {
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    }
}

