/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.dreceiptx.receipt.allowanceCharge.ReceiptAllowanceCharge;
import net.dreceiptx.receipt.common.Contact;
import net.dreceiptx.receipt.common.ContactInformation;
import net.dreceiptx.receipt.common.ContactType;
import net.dreceiptx.receipt.common.DespatchInformation;
import net.dreceiptx.receipt.tax.Tax;

public class DeliveryInformation {
    private final ContactInformation _contactInformation = new ContactInformation();
    private List<ReceiptAllowanceCharge> _deliveryFees;
    private final DespatchInformation _despatchInformation = new DespatchInformation();

    public DeliveryInformation() {
        this._deliveryFees = new ArrayList<ReceiptAllowanceCharge>();
    }

    public DeliveryInformation setName(String deliveryName) {
        this._contactInformation.getAddress().setName(deliveryName);
        return this;
    }

    public DeliveryInformation setAddress(String streetAddress1, String city, String postalCode, String state, String countryCode) {
        this._contactInformation.getAddress().setStreetAddress1(streetAddress1);
        this._contactInformation.getAddress().setCity(city);
        this._contactInformation.getAddress().setPostalCode(postalCode);
        this._contactInformation.getAddress().setState(state);
        this._contactInformation.getAddress().setCountryCode(countryCode);
        return this;
    }

    public DeliveryInformation setStreetAddress2(String streetAddress2) {
        this._contactInformation.getAddress().setStreetAddress2(streetAddress2);
        return this;
    }

    public DeliveryInformation setStreetAddress3(String streetAddress3) {
        this._contactInformation.getAddress().setStreetAddress3(streetAddress3);
        return this;
    }

    public DeliveryInformation addDeliveryFee(Double deliveryFee, String description) {
        this._deliveryFees.add(ReceiptAllowanceCharge.DeliveryFee(deliveryFee, description));
        return this;
    }

    public DeliveryInformation addDeliveryFee(Double deliveryFee, String description, Tax tax) {
        this._deliveryFees.add(ReceiptAllowanceCharge.DeliveryFee(deliveryFee, description, tax));
        return this;
    }

    public DeliveryInformation sddDeliveryDate(Date deliveryDate) {
        this._despatchInformation.setDeliveryDate(deliveryDate);
        return this;
    }

    public DeliveryInformation addDeliveryInstructions(String instructions) {
        this._despatchInformation.setInstructions(instructions);
        return this;
    }

    public DeliveryInformation addDespatchDate(Date despatchDate) {
        this._despatchInformation.setDespatchDate(despatchDate);
        return this;
    }

    public DeliveryInformation addContact(ContactType type, String value) {
        this._contactInformation.getContacts().add(new Contact(type, value));
        return this;
    }

    public ContactInformation getContactInformation() {
        return this._contactInformation;
    }

    public List<ReceiptAllowanceCharge> getDeliveryFees() {
        return this._deliveryFees;
    }

    public DespatchInformation getDespatchInformation() {
        return this._despatchInformation;
    }
}

