/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.allowanceCharge;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.dreceiptx.receipt.allowanceCharge.AllowanceChargeType;
import net.dreceiptx.receipt.allowanceCharge.AllowanceOrChargeType;
import net.dreceiptx.receipt.allowanceCharge.SettlementType;
import net.dreceiptx.receipt.tax.Tax;
import net.dreceiptx.receipt.tax.TaxCode;

public class ReceiptAllowanceCharge {
    private transient int Id;
    @SerializedName(value="allowanceOrChargeType")
    private AllowanceOrChargeType _allowanceOrChargeType;
    @SerializedName(value="allowanceChargeType")
    private AllowanceChargeType _allowanceChargeType;
    @SerializedName(value="settlementType")
    private SettlementType _settlementType;
    @SerializedName(value="baseAmount")
    private double _amount;
    @SerializedName(value="allowanceChargeDescription")
    private String _description;
    @SerializedName(value="leviedDutyFeeTax")
    private List<Tax> _taxes = new ArrayList<Tax>();

    public double getId() {
        return this.Id;
    }

    public SettlementType getType() {
        return this._settlementType;
    }

    public double getSubTotal() {
        return this._amount;
    }

    public String getDescription() {
        return this._description;
    }

    public double getNetTotal() {
        return this._amount;
    }

    public double getTotal() {
        double total = this._amount;
        return total += this.getTaxesTotal();
    }

    public Boolean hasTaxes() {
        return !this._taxes.isEmpty();
    }

    public double getTaxesTotal() {
        Double totalTaxes = 0.0;
        for (Tax tax : this._taxes) {
            totalTaxes = tax.getTaxTotal();
        }
        return totalTaxes;
    }

    public double getTaxesTotal(TaxCode taxCode) {
        Double totalTaxes = 0.0;
        for (Tax tax : this._taxes) {
            if (!tax.getTaxCode().equals((Object)taxCode)) continue;
            totalTaxes = tax.getTaxTotal();
        }
        return totalTaxes;
    }

    public List<Tax> getTaxes() {
        return this._taxes;
    }

    public Boolean isCharge() {
        return this._allowanceOrChargeType == AllowanceOrChargeType.CHARGE;
    }

    public Boolean isAllowance() {
        return this._allowanceOrChargeType == AllowanceOrChargeType.ALLOWANCE;
    }

    public static ReceiptAllowanceCharge Tip(double amount, String description) {
        ReceiptAllowanceCharge receiptAllowanceCharge = new ReceiptAllowanceCharge();
        receiptAllowanceCharge._amount = amount;
        receiptAllowanceCharge._description = description;
        receiptAllowanceCharge._allowanceOrChargeType = AllowanceOrChargeType.CHARGE;
        receiptAllowanceCharge._allowanceChargeType = AllowanceChargeType.CHARGE_TO_BE_PAID_BY_CUSTOMER;
        receiptAllowanceCharge._settlementType = SettlementType.TIP;
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge Tip(double amount, String description, Tax tax) {
        ReceiptAllowanceCharge receiptAllowanceCharge = ReceiptAllowanceCharge.Tip(amount, description);
        receiptAllowanceCharge._taxes.add(tax);
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge DeliveryFee(double amount, String description) {
        ReceiptAllowanceCharge receiptAllowanceCharge = new ReceiptAllowanceCharge();
        receiptAllowanceCharge._amount = amount;
        receiptAllowanceCharge._description = description;
        receiptAllowanceCharge._allowanceOrChargeType = AllowanceOrChargeType.CHARGE;
        receiptAllowanceCharge._allowanceChargeType = AllowanceChargeType.CHARGE_TO_BE_PAID_BY_CUSTOMER;
        receiptAllowanceCharge._settlementType = SettlementType.DeliveryFee;
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge DeliveryFee(double amount, String description, Tax tax) {
        ReceiptAllowanceCharge receiptAllowanceCharge = ReceiptAllowanceCharge.DeliveryFee(amount, description);
        receiptAllowanceCharge._taxes.add(tax);
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge FreightFee(double amount, String description) {
        ReceiptAllowanceCharge receiptAllowanceCharge = new ReceiptAllowanceCharge();
        receiptAllowanceCharge._amount = amount;
        receiptAllowanceCharge._description = description;
        receiptAllowanceCharge._allowanceOrChargeType = AllowanceOrChargeType.CHARGE;
        receiptAllowanceCharge._allowanceChargeType = AllowanceChargeType.CHARGE_TO_BE_PAID_BY_CUSTOMER;
        receiptAllowanceCharge._settlementType = SettlementType.FreightFee;
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge FreightFee(double amount, String description, Tax tax) {
        ReceiptAllowanceCharge receiptAllowanceCharge = ReceiptAllowanceCharge.FreightFee(amount, description);
        receiptAllowanceCharge._taxes.add(tax);
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge PackagingFee(double amount, String description) {
        ReceiptAllowanceCharge receiptAllowanceCharge = new ReceiptAllowanceCharge();
        receiptAllowanceCharge._amount = amount;
        receiptAllowanceCharge._description = description;
        receiptAllowanceCharge._allowanceOrChargeType = AllowanceOrChargeType.CHARGE;
        receiptAllowanceCharge._allowanceChargeType = AllowanceChargeType.CHARGE_TO_BE_PAID_BY_CUSTOMER;
        receiptAllowanceCharge._settlementType = SettlementType.PackagingFee;
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge PackagingFee(double amount, String description, Tax tax) {
        ReceiptAllowanceCharge receiptAllowanceCharge = ReceiptAllowanceCharge.PackagingFee(amount, description);
        receiptAllowanceCharge._taxes.add(tax);
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge ProcessingFee(double amount, String description) {
        ReceiptAllowanceCharge receiptAllowanceCharge = new ReceiptAllowanceCharge();
        receiptAllowanceCharge._amount = amount;
        receiptAllowanceCharge._description = description;
        receiptAllowanceCharge._allowanceOrChargeType = AllowanceOrChargeType.CHARGE;
        receiptAllowanceCharge._allowanceChargeType = AllowanceChargeType.CHARGE_TO_BE_PAID_BY_CUSTOMER;
        receiptAllowanceCharge._settlementType = SettlementType.PackagingFee;
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge ProcessingFee(double amount, String description, Tax tax) {
        ReceiptAllowanceCharge receiptAllowanceCharge = ReceiptAllowanceCharge.ProcessingFee(amount, description);
        receiptAllowanceCharge._taxes.add(tax);
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge BookingFee(double amount, String description) {
        ReceiptAllowanceCharge receiptAllowanceCharge = new ReceiptAllowanceCharge();
        receiptAllowanceCharge._amount = amount;
        receiptAllowanceCharge._description = description;
        receiptAllowanceCharge._allowanceOrChargeType = AllowanceOrChargeType.CHARGE;
        receiptAllowanceCharge._allowanceChargeType = AllowanceChargeType.CHARGE_TO_BE_PAID_BY_CUSTOMER;
        receiptAllowanceCharge._settlementType = SettlementType.BookingFee;
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge BookingFee(double amount, String description, Tax tax) {
        ReceiptAllowanceCharge receiptAllowanceCharge = ReceiptAllowanceCharge.BookingFee(amount, description);
        receiptAllowanceCharge._taxes.add(tax);
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge GeneralDiscount(double amount, String description) {
        ReceiptAllowanceCharge receiptAllowanceCharge = new ReceiptAllowanceCharge();
        receiptAllowanceCharge._amount = amount;
        receiptAllowanceCharge._description = description;
        receiptAllowanceCharge._allowanceOrChargeType = AllowanceOrChargeType.ALLOWANCE;
        receiptAllowanceCharge._allowanceChargeType = AllowanceChargeType.CREDIT_CUSTOMER_ACCOUNT;
        receiptAllowanceCharge._settlementType = SettlementType.GeneralDiscount;
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge GeneralDiscount(double amount, String description, Tax tax) {
        ReceiptAllowanceCharge receiptAllowanceCharge = ReceiptAllowanceCharge.GeneralDiscount(amount, description);
        receiptAllowanceCharge._taxes.add(tax);
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge MultiBuyDiscount(double amount, String description) {
        ReceiptAllowanceCharge receiptAllowanceCharge = new ReceiptAllowanceCharge();
        receiptAllowanceCharge._amount = amount;
        receiptAllowanceCharge._description = description;
        receiptAllowanceCharge._allowanceOrChargeType = AllowanceOrChargeType.ALLOWANCE;
        receiptAllowanceCharge._allowanceChargeType = AllowanceChargeType.CREDIT_CUSTOMER_ACCOUNT;
        receiptAllowanceCharge._settlementType = SettlementType.MultiBuyDiscount;
        return receiptAllowanceCharge;
    }

    public static ReceiptAllowanceCharge MultiBuyDiscount(double amount, String description, Tax tax) {
        ReceiptAllowanceCharge receiptAllowanceCharge = ReceiptAllowanceCharge.MultiBuyDiscount(amount, description);
        receiptAllowanceCharge._taxes.add(tax);
        return receiptAllowanceCharge;
    }
}

