/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.users;

public class User {
    private UserIdentifierType _identifierType;
    private String _identifier;
    private Boolean _identifierIsHashed = false;
    private String _guid;
    private String _rms;

    public User() {
    }

    public User(UserIdentifierType _identifierType, String _identifier) {
        this._identifierType = _identifierType;
        this._identifier = _identifier;
    }

    public User(UserIdentifierType _identifierType, String _identifier, String _guid) {
        this._identifierType = _identifierType;
        this._identifier = _identifier;
        this._guid = _guid;
    }

    public UserIdentifierType getIdentifierType() {
        return _identifierType;
    }

    public void setIdentifierType(UserIdentifierType _identifierType) {
        this._identifierType = _identifierType;
    }

    public String getIdentifier() {
        return _identifier;
    }

    public void setIdentifier(String _identifier) {
        this._identifier = _identifier;
    }

    public Boolean isIdentifierHashed() {
        return _identifierIsHashed;
    }

    public void setGUID(String guid){
        _guid = guid;
    }
    
    public String getGUID(){
        return _guid;
    }
    
    public void setRMS(String rms){
        _rms = rms;
    }
    
    public String getRMS(){
        return _rms;
    }
}
