/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.users;

import java.util.HashMap;
import java.util.Map;

public class NewUser {
    private String _email; 
    private final Map<UserIdentifierType, String> _identifiers = new HashMap<>(); 
    private final Map<UserConfigOptionType, String> _config = new HashMap<>();
    private Boolean _addEmailAsIdentifier = true;
    
    public NewUser() {
    }

    public NewUser(String _email) {
        this.setUserEmail(_email);
    }

    public NewUser(String _email, Boolean _addAsIdentifier) {
        _addEmailAsIdentifier = _addAsIdentifier;
        this.setUserEmail(_email);
    }
    
    public void setUserEmail(String _email){
        this._email = _email;
        if(_addEmailAsIdentifier){
            _identifiers.put(UserIdentifierType.EMAIL, _email);
        }
    }
    
    public void setUserEmail(String _email, Boolean _addAsIdentifier){
        _addEmailAsIdentifier = _addAsIdentifier;
        this.setUserEmail(_email);
    }

    public String getEmail() {
        return _email;
    }

    public void addIdentifier( UserIdentifierType identifierType, String identifier){
        _identifiers.put(identifierType, identifier);
    }
    
    public Map<UserIdentifierType, String> getIdentifiers() {
        return _identifiers;
    }
    
    public void addConfigOption( UserConfigOptionType configOptionType, String optionValue){
        _config.put(configOptionType, optionValue);
    }
    
    public Map<UserConfigOptionType, String> getConfig() {
        return _config;
    }
}
