/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.lineitem.travel;

import net.dreceiptx.receipt.invoice.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.LineItem;
import java.util.Date;

public class Flight extends LineItem {
    public static final String LineItemTypeValue = "TRAVEL_FLIGHT";
    private static final String _tradeItemIdentificationPassenger = "PASSENGER_NAME";

    public Flight(String airline, String itinerary, String itineraryDescription, int quantity, double price) {
        super(airline, itinerary, itineraryDescription, quantity, price);
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, Flight.LineItemTypeValue);
    }

    public Flight(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, Flight.LineItemTypeValue);
    }
    
    public String getAirline(){
        return this.getBrandName();
    }
    
    public String getItinerary(){
        return this.getName();
    }
    
    public String getItineraryDescription(){
        return this.getDescription();
    }
    
    public void setPassengerName(String passengerName){
        this.addTradeItemIdentification(_tradeItemIdentificationPassenger, passengerName);
    }
    
    public String getPassengerName(){
        return this.getTradeItemIdentificationValue(_tradeItemIdentificationPassenger);
    }
    
    public Date getDepartureDate(){
        return this.getDespatchDate();
    }
    
    public void setDepartureDate(Date departureDate){
        this.setDespatchDate(departureDate);
    }
    
    public void setTicketNumber(String ticketNumber){
        this._serialNumber = ticketNumber;
    }
    
    public String getTicketNumber(){
        return this._serialNumber;
    }
}