/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.common;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class ContactInformation {
    @SerializedName("address") private Address _address;
    @SerializedName("contact") private List<Contact> _contacts = new ArrayList<>();
    
    public ContactInformation(){
    }
    
    public ContactInformation(Address address, Contact contact){
        _address = address;
        _contacts.add(contact);
    }
    
    public ContactInformation(Address address){
        _address = address;
    }
    
    public ContactInformation(Contact contact){
        _contacts.add(contact);
    }
    
    public void addContact(Contact contact){
        _contacts.add(contact);
    }

    public Address getAddress() {
        if(_address ==  null){
            _address = new Address();
        }
        return _address;
    }
    
    public List<Contact> getContacts() {
        return _contacts;
    }
    
    public Boolean gsonValidator(){
        return _address != null || !_contacts.isEmpty();

    }
}
