/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.client;

import net.dreceiptx.receipt.DigitalReceipt;
import net.dreceiptx.receipt.DigitalReceiptGenerator;
import net.dreceiptx.receipt.merchant.Merchant;
import net.dreceiptx.users.NewUser;
import net.dreceiptx.users.NewUserRegistrationResult;
import net.dreceiptx.users.User;
import net.dreceiptx.users.UserIdentifierType;
import net.dreceiptx.users.Users;
import net.dreceiptx.client.exception.ExchangeClientException;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface ExchangeClient {

    /**
     * @param identiferType
     * @param identifer
     * @return The matching users will be returned if it is found otherwise null
     * @throws ExchangeClientException will be thrown if problem calling the service.
     */
    User searchUser(UserIdentifierType identiferType, String identifer) throws ExchangeClientException;

    /**
     * @param identiferType
     * @param userIdentifiers
     * @param hashed
     * @return The matching users will be returned if it is found otherwise null
     * @throws ExchangeClientException will be thrown if problem calling the service.
     */
    Users searchUsers(UserIdentifierType identiferType, ArrayList<String> userIdentifiers, Boolean hashed) throws ExchangeClientException;
    
    /**
     * @param receipt
     * @return newReceiptGUID
     * @throws ExchangeClientException will be thrown if problem calling the service.
     */
    String sendReceipt(DigitalReceiptGenerator receipt) throws ExchangeClientException;

    
    /**
     * @param newUser
     * @return newUserGUID
     * @throws ExchangeClientException will be thrown if problem calling the service.
     */
    public NewUserRegistrationResult registerNewUser(NewUser newUser) throws ExchangeClientException;
    
    /**
     * @param NewUserCollection
     * @return Map<String, String>
     * @throws ExchangeClientException will be thrown if problem calling the service.
     */
    public Map<String, NewUserRegistrationResult> registerNewUser(List<NewUser> newUsers) throws ExchangeClientException;
    
    /**
     * @param receiptId
     * @return
     * @throws ExchangeClientException will be thrown if problem calling the service.
     */
    DigitalReceipt lookupReceipt(String receiptId) throws ExchangeClientException;

    /**
     * @param receiptId
     * @return
     * @throws ExchangeClientException will be thrown if problem calling the service.
     */
    boolean downloadReceiptPDF(String receiptId) throws ExchangeClientException;


    /**
     * @param Id
     * @return
     * @throws ExchangeClientException will be thrown if problem calling the service.
     */
    Merchant lookupMerchant(String Id) throws ExchangeClientException;

}
