/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.tax;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import net.dreceiptx.receipt.tax.TaxCategory;
import net.dreceiptx.receipt.tax.TaxCode;

public class Tax {
    @SerializedName(value="dutyFeeTaxCategoryCode")
    private TaxCategory _category = null;
    @SerializedName(value="dutyFeeTaxTypeCode")
    private TaxCode _code = null;
    @SerializedName(value="dutyFeeTaxBasisAmount")
    private BigDecimal _taxableAmount;
    @SerializedName(value="dutyFeeTaxPercentage")
    private BigDecimal _rate;
    @SerializedName(value="dutyFeeTaxAmount")
    private BigDecimal _totalTax;

    public Tax(double taxableAmount, double totalTax) {
        this._taxableAmount = BigDecimal.valueOf(taxableAmount);
        this._totalTax = BigDecimal.valueOf(totalTax);
        this._rate = totalTax != 0.0 ? this._totalTax.divide(this._taxableAmount, 5).multiply(new BigDecimal(100)).setScale(2, 6) : BigDecimal.ZERO;
    }

    public Tax(TaxCategory category, TaxCode code, double taxableAmount, double totalTax) {
        this(taxableAmount, totalTax);
        this._category = category;
        this._code = code;
    }

    public void setTaxCategory(TaxCategory taxCategory) {
        this._category = taxCategory;
    }

    public void setTaxCode(TaxCode taxCode) {
        this._code = taxCode;
    }

    public BigDecimal getTaxRate() {
        return this._rate;
    }

    public BigDecimal getTaxableAmount() {
        return this._taxableAmount;
    }

    public BigDecimal getTaxTotal() {
        return this._totalTax;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this._totalTax = taxTotal;
    }

    public TaxCategory getTaxCategory() {
        return this._category;
    }

    public TaxCode getTaxCode() {
        return this._code;
    }

    public boolean is(TaxCode taxCode) {
        return taxCode == this._code;
    }
}

