/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem.travel;

import java.math.BigDecimal;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;
import net.dreceiptx.receipt.lineitem.travel.TravelIncidentalType;

public class TravelIncidental
extends LineItem {
    public static final String LineItemTypeValue = "TRAVEL0010";

    public TravelIncidental(TravelIncidentalType incidentalType, String provider, String shortDescription, String longDescription, BigDecimal quantity, BigDecimal price) {
        super(provider, shortDescription, longDescription, quantity, price);
        this.setTradeItemGroupIdentificationCode(incidentalType.code());
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public TravelIncidental(TradeItemDescriptionInformation tradeItemDescriptionInformation, BigDecimal quantity, BigDecimal price) {
        this(tradeItemDescriptionInformation, quantity.doubleValue(), price.doubleValue());
    }

    public TravelIncidental(TradeItemDescriptionInformation tradeItemDescriptionInformation, double quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public String getServiceProviderName() {
        return this.getBrandName();
    }

    public String getShortDescription() {
        return this.getName();
    }

    public String getDetailedDescription() {
        return this.getDescription();
    }

    public TravelIncidentalType getIncidentalType() {
        return (TravelIncidentalType)this.getLineItemType(TravelIncidentalType.class, TravelIncidentalType.Standard);
    }

    @Override
    public String getLineItemTypeValue() {
        return LineItemTypeValue;
    }
}

