/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem.entertainment;

import net.dreceiptx.receipt.ecom.AVPType;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;
import net.dreceiptx.receipt.lineitem.entertainment.EntertainmentType;

public class Entertainment
extends LineItem {
    public static final String LineItemTypeValue = "ENT0001";

    public Entertainment(EntertainmentType entertainmentType, String provider, String shortDescription, String longDescription, int quantity, double price) {
        super(provider, shortDescription, longDescription, quantity, price);
        this.setTradeItemGroupIdentificationCode(entertainmentType.code());
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public Entertainment(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        this(tradeItemDescriptionInformation, (double)quantity, price);
    }

    public Entertainment(TradeItemDescriptionInformation tradeItemDescriptionInformation, double quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public String getServiceProviderName() {
        return this.getBrandName();
    }

    public void setIncludesAlcohol(boolean includesAlcohol) {
        this._AVPList.add(AVPType.INCLUDES_ALCOHOL.Code(), String.valueOf(includesAlcohol));
    }

    public Boolean getIncludesAlcohol() {
        try {
            return Boolean.valueOf(this._AVPList.get(AVPType.INCLUDES_ALCOHOL.Code()).getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getShortDescription() {
        return this.getName();
    }

    public String getDetailedDescription() {
        return this.getDescription();
    }

    public EntertainmentType getEntertainmentType() {
        return (EntertainmentType)this.getLineItemType(EntertainmentType.class, EntertainmentType.Standard);
    }

    @Override
    public String getLineItemTypeValue() {
        return LineItemTypeValue;
    }
}

