/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.common;

import java.util.HashMap;
import java.util.Map;

public enum Language {
    Chinese("zh", "Chinese"),
    English("en", "English"),
    French("fr", "French"),
    German("de", "German"),
    Italian("it", "Italian");

    private String _code;
    private String _displayName;
    private static Map<String, Language> enums;

    private Language(String value, String name) {
        this._code = value;
        this._displayName = name;
    }

    public String getCode() {
        return this._code;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String toString() {
        return this._displayName;
    }

    private Language(String languageCode) {
        this._code = languageCode;
    }

    public static Language codeOf(String languageCode) {
        if (!enums.containsKey(languageCode)) {
            throw new RuntimeException("Unknown Language Code [" + languageCode + "] supplied, please supply a valid and supported Language");
        }
        return enums.get(languageCode);
    }

    static {
        enums = new HashMap<String, Language>();
        for (Language language : Language.values()) {
            enums.put(language._code, language);
        }
    }
}

