/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.dreceiptx.receipt.allowanceCharge.ReceiptAllowanceCharge;
import net.dreceiptx.receipt.common.Contact;
import net.dreceiptx.receipt.common.ContactType;
import net.dreceiptx.receipt.common.DespatchInformation;
import net.dreceiptx.receipt.common.LocationInformation;
import net.dreceiptx.receipt.tax.Tax;

public class DeliveryInformation {
    private final LocationInformation _locationInformation = new LocationInformation();
    private List<ReceiptAllowanceCharge> _deliveryFees;
    private final DespatchInformation _despatchInformation = new DespatchInformation();

    public DeliveryInformation() {
        this._deliveryFees = new ArrayList<ReceiptAllowanceCharge>();
    }

    public DeliveryInformation setName(String deliveryName) {
        this._locationInformation.getAddress().setName(deliveryName);
        return this;
    }

    public DeliveryInformation setAddress(String streetAddress1, String city, String postalCode, String state, String countryCode) {
        this._locationInformation.getAddress().setStreetAddress1(streetAddress1);
        this._locationInformation.getAddress().setCity(city);
        this._locationInformation.getAddress().setPostalCode(postalCode);
        this._locationInformation.getAddress().setState(state);
        this._locationInformation.getAddress().setCountryCode(countryCode);
        return this;
    }

    public DeliveryInformation setStreetAddress2(String streetAddress2) {
        this._locationInformation.getAddress().setStreetAddress2(streetAddress2);
        return this;
    }

    public DeliveryInformation setStreetAddress3(String streetAddress3) {
        this._locationInformation.getAddress().setStreetAddress3(streetAddress3);
        return this;
    }

    public DeliveryInformation addDeliveryFee(Double deliveryFee, String description) {
        this._deliveryFees.add(ReceiptAllowanceCharge.DeliveryFee(deliveryFee, description));
        return this;
    }

    public DeliveryInformation addDeliveryFee(Double deliveryFee, String description, Tax tax) {
        this._deliveryFees.add(ReceiptAllowanceCharge.DeliveryFee(deliveryFee, description, tax));
        return this;
    }

    public DeliveryInformation sddDeliveryDate(Date deliveryDate) {
        this._despatchInformation.setDeliveryDate(deliveryDate);
        return this;
    }

    public DeliveryInformation addDeliveryInstructions(String instructions) {
        this._despatchInformation.setInstructions(instructions);
        return this;
    }

    public DeliveryInformation addDespatchDate(Date despatchDate) {
        this._despatchInformation.setDespatchDate(despatchDate);
        return this;
    }

    public DeliveryInformation addContact(ContactType type, String value) {
        this._locationInformation.getContacts().add(new Contact(type, value));
        return this;
    }

    public LocationInformation getLocationInformation() {
        return this._locationInformation;
    }

    public List<ReceiptAllowanceCharge> getDeliveryFees() {
        return this._deliveryFees;
    }

    public DespatchInformation getDespatchInformation() {
        return this._despatchInformation;
    }
}

