/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.common;

import java.util.HashMap;
import java.util.Map;

public enum Currency {
    Afghani("AFN", "Afghani"),
    Euro("EUR", "Euro"),
    Lek("ALL", "Lek"),
    AlgerianDinar("DZD", "Algerian Dinar"),
    USDollar("USD", "US Dollar"),
    Kwanza("AOA", "Kwanza"),
    EastCaribbeanDollar("XCD", "East Caribbean Dollar"),
    ArgentinePeso("ARS", "Argentine Peso"),
    ArmenianDram("AMD", "Armenian Dram"),
    ArubanFlorin("AWG", "Aruban Florin"),
    AustralianDollar("AUD", "Australian Dollar"),
    AzerbaijanianManat("AZN", "Azerbaijanian Manat"),
    BahamianDollar("BSD", "Bahamian Dollar"),
    BahrainiDinar("BHD", "Bahraini Dinar"),
    Taka("BDT", "Taka"),
    BarbadosDollar("BBD", "Barbados Dollar"),
    BelarussianRuble("BYR", "Belarussian Ruble"),
    BelizeDollar("BZD", "Belize Dollar"),
    CFAFrancBCEAO("XOF", "CFA Franc BCEAO"),
    BermudianDollar("BMD", "Bermudian Dollar"),
    Ngultrum("BTN", "Ngultrum"),
    IndianRupee("INR", "Indian Rupee"),
    Boliviano("BOB", "Boliviano"),
    Mvdol("BOV", "Mvdol"),
    ConvertibleMark("BAM", "Convertible Mark"),
    Pula("BWP", "Pula"),
    NorwegianKrone("NOK", "Norwegian Krone"),
    BrazilianReal("BRL", "Brazilian Real"),
    BruneiDollar("BND", "Brunei Dollar"),
    BulgarianLev("BGN", "Bulgarian Lev"),
    BurundiFranc("BIF", "Burundi Franc"),
    CaboVerdeEscudo("CVE", "Cabo Verde Escudo"),
    Riel("KHR", "Riel"),
    CFAFrancBEAC("XAF", "CFA Franc BEAC"),
    CanadianDollar("CAD", "Canadian Dollar"),
    CaymanIslandsDollar("KYD", "Cayman Islands Dollar"),
    UnidaddeFomento("CLF", "Unidad de Fomento"),
    ChileanPeso("CLP", "Chilean Peso"),
    YuanRenminbi("CNY", "Yuan Renminbi"),
    ColombianPeso("COP", "Colombian Peso"),
    UnidaddeValorReal("COU", "Unidad de Valor Real"),
    ComoroFranc("KMF", "Comoro Franc"),
    CongoleseFranc("CDF", "Congolese Franc"),
    NewZealandDollar("NZD", "New Zealand Dollar"),
    CostaRicanColon("CRC", "Costa Rican Colon"),
    Kuna("HRK", "Kuna"),
    PesoConvertible("CUC", "Peso Convertible"),
    CubanPeso("CUP", "Cuban Peso"),
    NetherlandsAntilleanGuilder("ANG", "Netherlands Antillean Guilder"),
    CzechKoruna("CZK", "Czech Koruna"),
    DanishKrone("DKK", "Danish Krone"),
    DjiboutiFranc("DJF", "Djibouti Franc"),
    DominicanPeso("DOP", "Dominican Peso"),
    EgyptianPound("EGP", "Egyptian Pound"),
    ElSalvadorColon("SVC", "El Salvador Colon"),
    Nakfa("ERN", "Nakfa"),
    EthiopianBirr("ETB", "Ethiopian Birr"),
    FalklandIslandsPound("FKP", "Falkland Islands Pound"),
    FijiDollar("FJD", "Fiji Dollar"),
    CFPFranc("XPF", "CFP Franc"),
    Dalasi("GMD", "Dalasi"),
    Lari("GEL", "Lari"),
    GhanaCedi("GHS", "Ghana Cedi"),
    GibraltarPound("GIP", "Gibraltar Pound"),
    Quetzal("GTQ", "Quetzal"),
    BritishSterling("GBP", "British Sterling(Pound)"),
    GuineaFranc("GNF", "Guinea Franc"),
    GuyanaDollar("GYD", "Guyana Dollar"),
    Gourde("HTG", "Gourde"),
    Lempira("HNL", "Lempira"),
    HongKongDollar("HKD", "Hong Kong Dollar"),
    Forint("HUF", "Forint"),
    IcelandKrona("ISK", "Iceland Krona"),
    Rupiah("IDR", "Rupiah"),
    IranianRial("IRR", "Iranian Rial"),
    IraqiDinar("IQD", "Iraqi Dinar"),
    NewIsraeliSheqel("ILS", "New Israeli Sheqel"),
    JamaicanDollar("JMD", "Jamaican Dollar"),
    Yen("JPY", "Yen"),
    JordanianDinar("JOD", "Jordanian Dinar"),
    Tenge("KZT", "Tenge"),
    KenyanShilling("KES", "Kenyan Shilling"),
    NorthKoreanWon("KPW", "North Korean Won"),
    Won("KRW", "Won"),
    KuwaitiDinar("KWD", "Kuwaiti Dinar"),
    Som("KGS", "Som"),
    Kip("LAK", "Kip"),
    LebanesePound("LBP", "Lebanese Pound"),
    Loti("LSL", "Loti"),
    Rand("ZAR", "Rand"),
    LiberianDollar("LRD", "Liberian Dollar"),
    LibyanDinar("LYD", "Libyan Dinar"),
    SwissFranc("CHF", "Swiss Franc"),
    Pataca("MOP", "Pataca"),
    Denar("MKD", "Denar"),
    MalagasyAriary("MGA", "Malagasy Ariary"),
    Kwacha("MWK", "Kwacha"),
    MalaysianRinggit("MYR", "Malaysian Ringgit"),
    Rufiyaa("MVR", "Rufiyaa"),
    Ouguiya("MRO", "Ouguiya"),
    MauritiusRupee("MUR", "Mauritius Rupee"),
    ADBUnitofAccount("XUA", "ADB Unit of Account"),
    MexicanPeso("MXN", "Mexican Peso"),
    MoldovanLeu("MDL", "Moldovan Leu"),
    Tugrik("MNT", "Tugrik"),
    MoroccanDirham("MAD", "Moroccan Dirham"),
    MozambiqueMetical("MZN", "Mozambique Metical"),
    Kyat("MMK", "Kyat"),
    NamibiaDollar("NAD", "Namibia Dollar"),
    NepaleseRupee("NPR", "Nepalese Rupee"),
    CordobaOro("NIO", "Cordoba Oro"),
    Naira("NGN", "Naira"),
    RialOmani("OMR", "Rial Omani"),
    PakistanRupee("PKR", "Pakistan Rupee"),
    Balboa("PAB", "Balboa"),
    Kina("PGK", "Kina"),
    Guarani("PYG", "Guarani"),
    NuevoSol("PEN", "Nuevo Sol"),
    PhilippinePeso("PHP", "Philippine Peso"),
    Zloty("PLN", "Zloty"),
    QatariRial("QAR", "Qatari Rial"),
    RomanianLeu("RON", "Romanian Leu"),
    RussianRuble("RUB", "Russian Ruble"),
    RwandaFranc("RWF", "Rwanda Franc"),
    SaintHelenaPound("SHP", "Saint Helena Pound"),
    Tala("WST", "Tala"),
    Dobra("STD", "Dobra"),
    SaudiRiyal("SAR", "Saudi Riyal"),
    SerbianDinar("RSD", "Serbian Dinar"),
    SeychellesRupee("SCR", "Seychelles Rupee"),
    Leone("SLL", "Leone"),
    SingaporeDollar("SGD", "Singapore Dollar"),
    Sucre("XSU", "Sucre"),
    SolomonIslandsDollar("SBD", "Solomon Islands Dollar"),
    SomaliShilling("SOS", "Somali Shilling"),
    SouthSudanesePound("SSP", "South Sudanese Pound"),
    SriLankaRupee("LKR", "Sri Lanka Rupee"),
    SudanesePound("SDG", "Sudanese Pound"),
    SurinamDollar("SRD", "Surinam Dollar"),
    Lilangeni("SZL", "Lilangeni"),
    SwedishKrona("SEK", "Swedish Krona"),
    WIREuro("CHE", "WIR Euro"),
    WIRFranc("CHW", "WIR Franc"),
    SyrianPound("SYP", "Syrian Pound"),
    NewTaiwanDollar("TWD", "New Taiwan Dollar"),
    Somoni("TJS", "Somoni"),
    TanzanianShilling("TZS", "Tanzanian Shilling"),
    Baht("THB", "Baht"),
    Paanga("TOP", "Pa\u00e2\u20ac\u2122anga"),
    TrinidadandTobagoDollar("TTD", "Trinidad and Tobago Dollar"),
    TunisianDinar("TND", "Tunisian Dinar"),
    TurkishLira("TRY", "Turkish Lira"),
    TurkmenistanNewManat("TMT", "Turkmenistan New Manat"),
    UgandaShilling("UGX", "Uganda Shilling"),
    Hryvnia("UAH", "Hryvnia"),
    UAEDirham("AED", "UAE Dirham"),
    PesoUruguayo("UYU", "Peso Uruguayo"),
    UzbekistanSum("UZS", "Uzbekistan Sum"),
    Vatu("VUV", "Vatu"),
    Bolivar("VEF", "Bolivar"),
    Dong("VND", "Dong"),
    YemeniRial("YER", "Yemeni Rial"),
    ZambianKwacha("ZMW", "Zambian Kwacha"),
    ZimbabweDollar("ZWL", "Zimbabwe Dollar");

    private String _code;
    private String _displayName;
    private static Map<String, Currency> enums;

    private Currency(String code, String name) {
        this._code = code;
        this._displayName = name;
    }

    public String getCode() {
        return this._code;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String toString() {
        return this._displayName;
    }

    private Currency(String currencyCode) {
        this._code = currencyCode;
    }

    public static Currency codeOf(String currencyCode) {
        if (!enums.containsKey(currencyCode)) {
            throw new RuntimeException("Unknown Currency Code [" + currencyCode + "] supplied, please supply a valid and supported Currency");
        }
        return enums.get(currencyCode);
    }

    static {
        enums = new HashMap<String, Currency>();
        for (Currency currency : Currency.values()) {
            enums.put(currency._code, currency);
        }
    }
}

