/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.common;

import java.util.HashMap;
import java.util.Map;

public enum Country {
    Australia("AUS", "Australia"),
    Canada("CAN", "Canada"),
    France("FRA", "France"),
    Ireland("IRE", "Ireland"),
    NewZealand("NZL", "NewZealand"),
    UnitedKingdom("GBR", "UnitedKingdom"),
    UnitedStatesOfAmerica("USA", "UnitedStatesOfAmerica");

    private String _code;
    private String _displayName;
    private static Map<String, Country> enums;

    private Country(String code, String name) {
        this._code = code;
        this._displayName = name;
    }

    public String getCode() {
        return this._code;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String toString() {
        return this._displayName;
    }

    private Country(String countryCode) {
        this._code = countryCode;
    }

    public static Country codeOf(String countryCode) {
        if (!enums.containsKey(countryCode)) {
            throw new RuntimeException("Unknown Country Code [" + countryCode + "] supplied, please supply a valid and supported Country");
        }
        return enums.get(countryCode);
    }

    static {
        enums = new HashMap<String, Country>();
        for (Country country : Country.values()) {
            enums.put(country._code, country);
        }
    }
}

