/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.client;

import net.dreceiptx.client.ExchangeCredentials;
import net.dreceiptx.client.exception.ExchangeClientException;

public final class EnvVarExchangeCredentials
implements ExchangeCredentials {
    private String _requesterId = this.getEnvVarOrThrow("DRX_REQUESTER_ID");
    private String _apiKey = this.getEnvVarOrThrow("DRX_API_KEY");
    private String _apiSecret = this.getEnvVarOrThrow("DRX_API_SECRET");

    private String getEnvVarOrThrow(String envVar) throws ExchangeClientException {
        String value = System.getenv(envVar);
        if (value == null || value.isEmpty()) {
            throw new ExchangeClientException(envVar + " can not be null or empty");
        }
        return value;
    }

    @Override
    public String getRequesterId() {
        return this._requesterId;
    }

    @Override
    public String getAPIKey() {
        return this._apiKey;
    }

    @Override
    public String getAPISecret() {
        return this._apiSecret;
    }
}

