/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.users;

import java.util.HashMap;
import java.util.Map;

public class NewUser {
    private String _email; 
    private final Map<UserIdentifierType, String> _identifiers = new HashMap<>(); 
    private final Map<UserConfigOptionType, String> _config = new HashMap<>();
    private boolean _addEmailAsIdentifier = true;
    
    public NewUser() {
    }

    public NewUser(String email) {
        setUserEmail(email);
    }

    public NewUser(String email, boolean _addAsIdentifier) {
        _addEmailAsIdentifier = _addAsIdentifier;
        setUserEmail(email);
    }
    
    public void setUserEmail(String email){
        _email = email;
        if(_addEmailAsIdentifier){
            _identifiers.put(UserIdentifierType.Email, email);
        }
    }
    
    public void setUserEmail(String email, boolean addAsIdentifier){
        _addEmailAsIdentifier = addAsIdentifier;
        setUserEmail(email);
    }

    public String getEmail() {
        return _email;
    }

    public void addIdentifier( UserIdentifierType identifierType, String identifier){
        _identifiers.put(identifierType, identifier);
    }
    
    public Map<UserIdentifierType, String> getIdentifiers() {
        return _identifiers;
    }
    
    public void addConfigOption( UserConfigOptionType configOptionType, String optionValue){
        _config.put(configOptionType, optionValue);
    }
    
    public Map<UserConfigOptionType, String> getConfig() {
        return _config;
    }
}
