/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.lineitem.travel;

import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;

import java.math.BigDecimal;

public class TravelIncidental extends LineItem {
    public static final String LineItemTypeValue = "TRAVEL0010";

    public TravelIncidental(TravelIncidentalType incidentalType, String provider, String shortDescription, String longDescription, BigDecimal quantity, BigDecimal price) {
        super(provider, shortDescription, longDescription, quantity, price);
        this.setTradeItemGroupIdentificationCode(incidentalType.code());
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, TravelIncidental.LineItemTypeValue);
    }

    public TravelIncidental(TradeItemDescriptionInformation tradeItemDescriptionInformation, BigDecimal quantity, BigDecimal price) {
        this(tradeItemDescriptionInformation, quantity.doubleValue(), price.doubleValue());
    }

    public TravelIncidental(TradeItemDescriptionInformation tradeItemDescriptionInformation, double quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, TravelIncidental.LineItemTypeValue);
    }

    public String getServiceProviderName(){
        return this.getBrandName();
    }

    public String getShortDescription(){
        return this.getName();
    }

    public String getDetailedDescription(){
        return this.getDescription();
    }

    public TravelIncidentalType getIncidentalType(){
        return (TravelIncidentalType)this.getLineItemType(TravelIncidentalType.class, TravelIncidentalType.Standard);
    }

    @Override
    public String getLineItemTypeValue() {
        return LineItemTypeValue;
    }
}