/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.lineitem.travel;

import net.dreceiptx.receipt.lineitem.LineItemTypeDescription;

public enum GroundTransportType implements LineItemTypeDescription {
    Standard("GTP0000", "Standard"),
    Taxi("GTP0001", "Taxi"),
    WaterTaxi("GTP0002", "Water Taxi"),
    RideSharing("GTP0010", "Ride Sharing"),
    CarPooling("GTP0011", "Car Sharing"),
    CarRental("GTP0012", "Car Rental"),
    PrivateCarRental("GTP0013", "Private Car Rental"),
    Train("GTP0020", "Train"),
    MetroTrain("GTP0021", "Local and metropolitan train"),
    NationalTrain("GTP0022", "National and regional train"),
    InternationalTrain("GTP0023", "International and intercontinental train"),
    TramOrLightRail("GTP0024", "Light rail, light rail transit or tram"),
    Bus("GTP00030", "Bus"),
    ShuttleBus("GTP00031", "Shuttle Bus"),
    MetroBus("GTP0032", "Local and metropolitan bus"),
    NationalBus("GTP0033", "National and regional bus"),
    InternationalBus("GTP0034", "International and intercontinental bus"),
    Ferry("GTP00040", "Ferry");

    private String code;
    private String description;

    GroundTransportType(String code, String description)
    {
        this.code = code;
        this.description = description;
    }

    public String code(){
        return this.code;
    }

    public String description(){
        return this.description;
    }
}
