/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.lineitem.construction;

import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;

import java.math.BigDecimal;

public class MaterialGeneric extends LineItem {
    public static final String LineItemTypeValue = "CON0001";

    public MaterialGeneric(String brandName, String productName, String productDescription, int quantity, double price) {
        super(brandName, productName, productDescription, quantity, price);
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, MaterialGeneric.LineItemTypeValue);
    }

    public MaterialGeneric(String brandName, String productName, String productDescription, double quantity, double price) {
        super(brandName, productName, productDescription, quantity, price);
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, MaterialGeneric.LineItemTypeValue);
    }

    public MaterialGeneric(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        this(tradeItemDescriptionInformation, (double)quantity, price);
    }

    public MaterialGeneric(TradeItemDescriptionInformation tradeItemDescriptionInformation, double quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, MaterialGeneric.LineItemTypeValue);
    }

    @Override
    public String getLineItemTypeValue() {
        return LineItemTypeValue;
    }
}