/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.common;

import com.google.gson.annotations.SerializedName;
import net.dreceiptx.receipt.tax.TaxCode;

public class TransactionalParty {
    @SerializedName("dutyFeeTaxRegistration") private DutyFeeTaxRegistration _dutyFeeTaxRegistration;
    @SerializedName("organisationDetails") private Organisation _organisation;

    public TransactionalParty(String name){
        _organisation = new Organisation(name);
    }

    public TransactionalParty(String name, TaxCode taxCode, String taxId){
        _organisation = new Organisation(name);
        _dutyFeeTaxRegistration = new DutyFeeTaxRegistration(taxCode, taxId);
    }

    public String getOrganisationName() {
        return _organisation.getOrganisationName();
    }

    public TaxCode getDutyFeeTaxTypeCode() {
        return _dutyFeeTaxRegistration.getDutyFeeTaxTypeCode();
    }

    public String getDutyFeeTaxRegistrationID() {
        return _dutyFeeTaxRegistration._dutyFeeTaxRegistrationID;
    }

    public class Organisation{
        @SerializedName("organisationName") private String _organisationName;

        public Organisation(String name){
            _organisationName = name;
        }

        public String getOrganisationName() {
            return _organisationName;
        }
    }

    public class DutyFeeTaxRegistration{
        @SerializedName("dutyFeeTaxTypeCode") private TaxCode _dutyFeeTaxTypeCode;
        @SerializedName("dutyFeeTaxRegistrationID") private String _dutyFeeTaxRegistrationID;

        public DutyFeeTaxRegistration(TaxCode code, String id){
            _dutyFeeTaxTypeCode = code;
            _dutyFeeTaxRegistrationID = id;
        }

        public String getDutyFeeTaxRegistrationID() {
            return _dutyFeeTaxRegistrationID;
        }

        public TaxCode getDutyFeeTaxTypeCode() {
            return _dutyFeeTaxTypeCode;
        }
    }
}
