/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.common.Measurement;

import com.google.gson.annotations.SerializedName;

public class TradeItemMeasurements {
    @SerializedName("depth") private Measurement _depth;
    @SerializedName("height") private Measurement _height;
    @SerializedName("width") private Measurement _width;
    @SerializedName("diameter") private Measurement _diameter;
    @SerializedName("netContent") private Measurement _netContent;

    public TradeItemMeasurements(double netContent, MeasurementType measurementType) {
        _netContent = new Measurement(netContent, measurementType);
    }

    public TradeItemMeasurements(double height, double width, double depth, MeasurementType measurementType) {
        _depth = new Measurement(depth, measurementType);
        _height = new Measurement(height, measurementType);
        _width = new Measurement(width, measurementType);
    }

    public void setNetContent(double netContent, MeasurementType measurementType) {
        _netContent = new Measurement(netContent, measurementType);
    }

    public void setMeasurements(double height, double width, double depth, MeasurementType measurementType) {
        _depth = new Measurement(depth, measurementType);
        _height = new Measurement(height, measurementType);
        _width = new Measurement(width, measurementType);
    }

    public Measurement getDepth() {
        return _depth;
    }

    public Measurement getHeight() {
        return _height;
    }

    public Measurement getWidth() {
        return _width;
    }

    public Measurement getDiameter() {
        return _diameter;
    }

    public Measurement getNetContent() {
        return _netContent;
    }
}
