/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.common.Measurement;

import com.google.gson.annotations.SerializedName;

public class Measurement {
    @SerializedName("measurementUnitCode") private MeasurementType _measurementType;
    @SerializedName("value") private double _value;

    public Measurement(double value, MeasurementType measurementType) {
        _value = value;
        _measurementType = measurementType;
    }

    public double getValue() {
        return _value;
    }

    public MeasurementType getMeasurementType() {
        return _measurementType;
    }

    @Override
    public String toString() {
        return _value+" "+_measurementType;
    }
}
