/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.common;

import com.google.gson.annotations.SerializedName;

import java.util.HashMap;
import java.util.Map;

public enum Language {
    @SerializedName("zh")
    Chinese("zh", "Chinese"),
    @SerializedName("en")
    English("en", "English"),
    @SerializedName("fr")
    French("fr", "French"),
    @SerializedName("de")
    German("de", "German"),
    @SerializedName("is")
    Italian("it", "Italian");

    private String _code;

    private String _displayName;

    private static Map<String, Language> enums = new HashMap<String, Language>();

    static {
        for (Language language : Language.values()) {
            enums.put(language._code, language);
        }
    }

    Language(String value, String name) {
        _code = value;
        _displayName = name;
    }

    public String getCode() {
        return _code;
    }

    public String getDisplayName() {
        return _displayName;
    }

    @Override
    public String toString() {
        return _displayName;
    }

    private Language(final String languageCode) { _code = languageCode; }

    public static Language codeOf(String languageCode) {
        if(!enums.containsKey(languageCode)){
            throw new RuntimeException("Unknown Language Code ["+languageCode+"] supplied, please supply a valid and supported Language");
        }
        return enums.get(languageCode);
    }
}
