/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.common;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;

public enum Currency {
    @SerializedName("AFN")
    Afghani("AFN", "Afghani"),
    @SerializedName("EUR")
    Euro("EUR", "Euro"),
    @SerializedName("ALL")
    Lek("ALL", "Lek"),
    @SerializedName("DZD")
    AlgerianDinar("DZD", "Algerian Dinar"),
    @SerializedName("USD")
    USDollar("USD", "US Dollar"),
    @SerializedName("AOA")
    Kwanza("AOA", "Kwanza"),
    @SerializedName("XCD")
    EastCaribbeanDollar("XCD", "East Caribbean Dollar"),
    @SerializedName("ARS")
    ArgentinePeso("ARS", "Argentine Peso"),
    @SerializedName("AMD")
    ArmenianDram("AMD", "Armenian Dram"),
    @SerializedName("AWG")
    ArubanFlorin("AWG", "Aruban Florin"),
    @SerializedName("AUD")
    AustralianDollar("AUD", "Australian Dollar"),
    @SerializedName("AZN")
    AzerbaijanianManat("AZN", "Azerbaijanian Manat"),
    @SerializedName("BSD")
    BahamianDollar("BSD", "Bahamian Dollar"),
    @SerializedName("BHD")
    BahrainiDinar("BHD", "Bahraini Dinar"),
    @SerializedName("BDT")
    Taka("BDT", "Taka"),
    @SerializedName("BBD")
    BarbadosDollar("BBD", "Barbados Dollar"),
    @SerializedName("BYR")
    BelarussianRuble("BYR", "Belarussian Ruble"),
    @SerializedName("BZD")
    BelizeDollar("BZD", "Belize Dollar"),
    @SerializedName("XOF")
    CFAFrancBCEAO("XOF", "CFA Franc BCEAO"),
    @SerializedName("BMD")
    BermudianDollar("BMD", "Bermudian Dollar"),
    @SerializedName("BTN")
    Ngultrum("BTN", "Ngultrum"),
    @SerializedName("INR")
    IndianRupee("INR", "Indian Rupee"),
    @SerializedName("BOB")
    Boliviano("BOB", "Boliviano"),
    @SerializedName("BOV")
    Mvdol("BOV", "Mvdol"),
    @SerializedName("BAM")
    ConvertibleMark("BAM", "Convertible Mark"),
    @SerializedName("BWP")
    Pula("BWP", "Pula"),
    @SerializedName("NOK")
    NorwegianKrone("NOK", "Norwegian Krone"),
    @SerializedName("BRL")
    BrazilianReal("BRL", "Brazilian Real"),
    @SerializedName("BND")
    BruneiDollar("BND", "Brunei Dollar"),
    @SerializedName("BGN")
    BulgarianLev("BGN", "Bulgarian Lev"),
    @SerializedName("BIF")
    BurundiFranc("BIF", "Burundi Franc"),
    @SerializedName("CVE")
    CaboVerdeEscudo("CVE", "Cabo Verde Escudo"),
    @SerializedName("KHR")
    Riel("KHR", "Riel"),
    @SerializedName("XAF")
    CFAFrancBEAC("XAF", "CFA Franc BEAC"),
    @SerializedName("CAD")
    CanadianDollar("CAD", "Canadian Dollar"),
    @SerializedName("KYD")
    CaymanIslandsDollar("KYD", "Cayman Islands Dollar"),
    @SerializedName("CLF")
    UnidaddeFomento("CLF", "Unidad de Fomento"),
    @SerializedName("CLP")
    ChileanPeso("CLP", "Chilean Peso"),
    @SerializedName("CNY")
    YuanRenminbi("CNY", "Yuan Renminbi"),
    @SerializedName("COP")
    ColombianPeso("COP", "Colombian Peso"),
    @SerializedName("COU")
    UnidaddeValorReal("COU", "Unidad de Valor Real"),
    @SerializedName("KMF")
    ComoroFranc("KMF", "Comoro Franc"),
    @SerializedName("CDF")
    CongoleseFranc("CDF", "Congolese Franc"),
    @SerializedName("NZD")
    NewZealandDollar("NZD", "New Zealand Dollar"),
    @SerializedName("CRC")
    CostaRicanColon("CRC", "Costa Rican Colon"),
    @SerializedName("HRK")
    Kuna("HRK", "Kuna"),
    @SerializedName("CUC")
    PesoConvertible("CUC", "Peso Convertible"),
    @SerializedName("CUP")
    CubanPeso("CUP", "Cuban Peso"),
    @SerializedName("ANG")
    NetherlandsAntilleanGuilder("ANG", "Netherlands Antillean Guilder"),
    @SerializedName("CZK")
    CzechKoruna("CZK", "Czech Koruna"),
    @SerializedName("DKK")
    DanishKrone("DKK", "Danish Krone"),
    @SerializedName("DJF")
    DjiboutiFranc("DJF", "Djibouti Franc"),
    @SerializedName("DOP")
    DominicanPeso("DOP", "Dominican Peso"),
    @SerializedName("EGP")
    EgyptianPound("EGP", "Egyptian Pound"),
    @SerializedName("SVC")
    ElSalvadorColon("SVC", "El Salvador Colon"),
    @SerializedName("ERN")
    Nakfa("ERN", "Nakfa"),
    @SerializedName("ETB")
    EthiopianBirr("ETB", "Ethiopian Birr"),
    @SerializedName("FKP")
    FalklandIslandsPound("FKP", "Falkland Islands Pound"),
    @SerializedName("FJD")
    FijiDollar("FJD", "Fiji Dollar"),
    @SerializedName("XPF")
    CFPFranc("XPF", "CFP Franc"),
    @SerializedName("GMD")
    Dalasi("GMD", "Dalasi"),
    @SerializedName("GEL")
    Lari("GEL", "Lari"),
    @SerializedName("GHS")
    GhanaCedi("GHS", "Ghana Cedi"),
    @SerializedName("GIP")
    GibraltarPound("GIP", "Gibraltar Pound"),
    @SerializedName("GTQ")
    Quetzal("GTQ", "Quetzal"),
    @SerializedName("GBP")
    BritishSterling("GBP", "British Sterling(Pound)"),
    @SerializedName("GNF")
    GuineaFranc("GNF", "Guinea Franc"),
    @SerializedName("GYD")
    GuyanaDollar("GYD", "Guyana Dollar"),
    @SerializedName("HTG")
    Gourde("HTG", "Gourde"),
    @SerializedName("HNL")
    Lempira("HNL", "Lempira"),
    @SerializedName("HKD")
    HongKongDollar("HKD", "Hong Kong Dollar"),
    @SerializedName("HUF")
    Forint("HUF", "Forint"),
    @SerializedName("ISK")
    IcelandKrona("ISK", "Iceland Krona"),
    @SerializedName("IDR")
    Rupiah("IDR", "Rupiah"),
    @SerializedName("IRR")
    IranianRial("IRR", "Iranian Rial"),
    @SerializedName("IQD")
    IraqiDinar("IQD", "Iraqi Dinar"),
    @SerializedName("ILS")
    NewIsraeliSheqel("ILS", "New Israeli Sheqel"),
    @SerializedName("JMD")
    JamaicanDollar("JMD", "Jamaican Dollar"),
    @SerializedName("JPY")
    Yen("JPY", "Yen"),
    @SerializedName("JOD")
    JordanianDinar("JOD", "Jordanian Dinar"),
    @SerializedName("KZT")
    Tenge("KZT", "Tenge"),
    @SerializedName("KES")
    KenyanShilling("KES", "Kenyan Shilling"),
    @SerializedName("KPW")
    NorthKoreanWon("KPW", "North Korean Won"),
    @SerializedName("KRW")
    Won("KRW", "Won"),
    @SerializedName("KWD")
    KuwaitiDinar("KWD", "Kuwaiti Dinar"),
    @SerializedName("KGS")
    Som("KGS", "Som"),
    @SerializedName("LAK")
    Kip("LAK", "Kip"),
    @SerializedName("LBP")
    LebanesePound("LBP", "Lebanese Pound"),
    @SerializedName("LSL")
    Loti("LSL", "Loti"),
    @SerializedName("ZAR")
    Rand("ZAR", "Rand"),
    @SerializedName("LRD")
    LiberianDollar("LRD", "Liberian Dollar"),
    @SerializedName("LYD")
    LibyanDinar("LYD", "Libyan Dinar"),
    @SerializedName("CHF")
    SwissFranc("CHF", "Swiss Franc"),
    @SerializedName("MOP")
    Pataca("MOP", "Pataca"),
    @SerializedName("MKD")
    Denar("MKD", "Denar"),
    @SerializedName("MGA")
    MalagasyAriary("MGA", "Malagasy Ariary"),
    @SerializedName("MWK")
    Kwacha("MWK", "Kwacha"),
    @SerializedName("MYR")
    MalaysianRinggit("MYR", "Malaysian Ringgit"),
    @SerializedName("MVR")
    Rufiyaa("MVR", "Rufiyaa"),
    @SerializedName("MRO")
    Ouguiya("MRO", "Ouguiya"),
    @SerializedName("MUR")
    MauritiusRupee("MUR", "Mauritius Rupee"),
    @SerializedName("XUA")
    ADBUnitofAccount("XUA", "ADB Unit of Account"),
    @SerializedName("MXN")
    MexicanPeso("MXN", "Mexican Peso"),
    @SerializedName("MDL")
    MoldovanLeu("MDL", "Moldovan Leu"),
    @SerializedName("MNT")
    Tugrik("MNT", "Tugrik"),
    @SerializedName("MAD")
    MoroccanDirham("MAD", "Moroccan Dirham"),
    @SerializedName("MZN")
    MozambiqueMetical("MZN", "Mozambique Metical"),
    @SerializedName("MMK")
    Kyat("MMK", "Kyat"),
    @SerializedName("NAD")
    NamibiaDollar("NAD", "Namibia Dollar"),
    @SerializedName("NPR")
    NepaleseRupee("NPR", "Nepalese Rupee"),
    @SerializedName("NIO")
    CordobaOro("NIO", "Cordoba Oro"),
    @SerializedName("NGN")
    Naira("NGN", "Naira"),
    @SerializedName("OMR")
    RialOmani("OMR", "Rial Omani"),
    @SerializedName("PKR")
    PakistanRupee("PKR", "Pakistan Rupee"),
    @SerializedName("PAB")
    Balboa("PAB", "Balboa"),
    @SerializedName("PGK")
    Kina("PGK", "Kina"),
    @SerializedName("PYG")
    Guarani("PYG", "Guarani"),
    @SerializedName("PEN")
    NuevoSol("PEN", "Nuevo Sol"),
    @SerializedName("PHP")
    PhilippinePeso("PHP", "Philippine Peso"),
    @SerializedName("PLN")
    Zloty("PLN", "Zloty"),
    @SerializedName("QAR")
    QatariRial("QAR", "Qatari Rial"),
    @SerializedName("RON")
    RomanianLeu("RON", "Romanian Leu"),
    @SerializedName("RUB")
    RussianRuble("RUB", "Russian Ruble"),
    @SerializedName("RWF")
    RwandaFranc("RWF", "Rwanda Franc"),
    @SerializedName("SHP")
    SaintHelenaPound("SHP", "Saint Helena Pound"),
    @SerializedName("WST")
    Tala("WST", "Tala"),
    @SerializedName("STD")
    Dobra("STD", "Dobra"),
    @SerializedName("SAR")
    SaudiRiyal("SAR", "Saudi Riyal"),
    @SerializedName("RSD")
    SerbianDinar("RSD", "Serbian Dinar"),
    @SerializedName("SCR")
    SeychellesRupee("SCR", "Seychelles Rupee"),
    @SerializedName("SLL")
    Leone("SLL", "Leone"),
    @SerializedName("SGD")
    SingaporeDollar("SGD", "Singapore Dollar"),
    @SerializedName("XSU")
    Sucre("XSU", "Sucre"),
    @SerializedName("SBD")
    SolomonIslandsDollar("SBD", "Solomon Islands Dollar"),
    @SerializedName("SOS")
    SomaliShilling("SOS", "Somali Shilling"),
    @SerializedName("SSP")
    SouthSudanesePound("SSP", "South Sudanese Pound"),
    @SerializedName("LKR")
    SriLankaRupee("LKR", "Sri Lanka Rupee"),
    @SerializedName("SDG")
    SudanesePound("SDG", "Sudanese Pound"),
    @SerializedName("SRD")
    SurinamDollar("SRD", "Surinam Dollar"),
    @SerializedName("SZL")
    Lilangeni("SZL", "Lilangeni"),
    @SerializedName("SEK")
    SwedishKrona("SEK", "Swedish Krona"),
    @SerializedName("CHE")
    WIREuro("CHE", "WIR Euro"),
    @SerializedName("CHW")
    WIRFranc("CHW", "WIR Franc"),
    @SerializedName("SYP")
    SyrianPound("SYP", "Syrian Pound"),
    @SerializedName("TWD")
    NewTaiwanDollar("TWD", "New Taiwan Dollar"),
    @SerializedName("TJS")
    Somoni("TJS", "Somoni"),
    @SerializedName("TZS")
    TanzanianShilling("TZS", "Tanzanian Shilling"),
    @SerializedName("THB")
    Baht("THB", "Baht"),
    @SerializedName("TOP")
    Paanga("TOP", "Pa’anga"),
    @SerializedName("TTD")
    TrinidadandTobagoDollar("TTD", "Trinidad and Tobago Dollar"),
    @SerializedName("TND")
    TunisianDinar("TND", "Tunisian Dinar"),
    @SerializedName("TRY")
    TurkishLira("TRY", "Turkish Lira"),
    @SerializedName("TMT")
    TurkmenistanNewManat("TMT", "Turkmenistan New Manat"),
    @SerializedName("UGX")
    UgandaShilling("UGX", "Uganda Shilling"),
    @SerializedName("UAH")
    Hryvnia("UAH", "Hryvnia"),
    @SerializedName("AED")
    UAEDirham("AED", "UAE Dirham"),
    @SerializedName("UYU")
    PesoUruguayo("UYU", "Peso Uruguayo"),
    @SerializedName("UZS")
    UzbekistanSum("UZS", "Uzbekistan Sum"),
    @SerializedName("VUV")
    Vatu("VUV", "Vatu"),
    @SerializedName("VEF")
    Bolivar("VEF", "Bolivar"),
    @SerializedName("VND")
    Dong("VND", "Dong"),
    @SerializedName("YER")
    YemeniRial("YER", "Yemeni Rial"),
    @SerializedName("ZMW")
    ZambianKwacha("ZMW", "Zambian Kwacha"),
    @SerializedName("ZWL")
    ZimbabweDollar("ZWL", "Zimbabwe Dollar");

    private String _code;

    private String _displayName;
    
    private static Map<String, Currency> enums = new HashMap<String, Currency>();

    static {
        for (Currency currency : Currency.values()) {
            enums.put(currency._code, currency);
        }
    }

    Currency(String code, String name) {
        _code = code;
        _displayName = name;
    }

    public String getCode() {
        return _code;
    }

    public String getDisplayName() {
        return _displayName;
    }

    @Override
    public String toString() {
        return _displayName;
    }
    
    private Currency(final String currencyCode) { _code = currencyCode; }

    public static Currency codeOf(String currencyCode) {
        if(!enums.containsKey(currencyCode)){
            throw new RuntimeException("Unknown Currency Code ["+currencyCode+"] supplied, please supply a valid and supported Currency");
        }
        return enums.get(currencyCode);
    }
}
