package net.dreceiptx.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import net.dreceiptx.config.Location;
import net.dreceiptx.receipt.common.Currency;
import net.dreceiptx.receipt.invoice.Invoice;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.serialization.json.DigitalReceiptSerializer;
import net.dreceiptx.receipt.serialization.json.InvoiceSerializer;
import net.dreceiptx.receipt.serialization.json.LineItemSerializer;
import net.dreceiptx.receipt.serialization.json.PaymentReceiptsSerializer;
import net.dreceiptx.receipt.settlement.PaymentReceipt;

import java.util.List;

public class ReceiptPostRequest {
    private DigitalReceiptSerializer digitalReceiptSerializer;
    private boolean isDryRun;
    private Location location;
    private Currency currency;
    private String userGUID;
    private String MerchantGLN;
    private String dRxGLN;

    public DigitalReceiptSerializer getDigitalReceiptSerializer() {
        return digitalReceiptSerializer;
    }

    public void setDigitalReceiptSerializer(DigitalReceiptSerializer digitalReceiptSerializer) {
        this.digitalReceiptSerializer = digitalReceiptSerializer;
    }

    public boolean isDryRun() {
        return isDryRun;
    }

    public void setDryRun(boolean dryRun) {
        isDryRun = dryRun;
    }

    public Location getLocation() {
        return location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Currency getCurrency() {
        return currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getUserGUID() {
        return userGUID;
    }

    public void setUserGUID(String userGUID) {
        this.userGUID = userGUID;
    }

    public String getMerchantGLN() {
        return MerchantGLN;
    }

    public void setMerchantGLN(String merchantGLN) {
        MerchantGLN = merchantGLN;
    }

    public String getdRxGLN() {
        return dRxGLN;
    }

    public void setdRxGLN(String dRxGLN) {
        this.dRxGLN = dRxGLN;
    }

    public String getJsonPayloadContent(){
        Gson gson = new GsonBuilder()
                .setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ")
                .registerTypeAdapter(Invoice.class, new InvoiceSerializer(currency))
                .registerTypeHierarchyAdapter(LineItem.class, new LineItemSerializer(currency))
                .registerTypeAdapter(new TypeToken<List<PaymentReceipt>>() {
                }.getType(), new PaymentReceiptsSerializer(dRxGLN, MerchantGLN, userGUID))
                .create();
        return gson.toJson(digitalReceiptSerializer);
    }
}
