/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.tax;

import java.util.HashMap;
import java.util.Map;

public enum TaxCode {
    TobaccoTax("AAD", "Tobacco tax"),
    CoffeeTax("AAF", "Coffee tax"),
    ExciseDuty("EXC", "Excise duty"),
    ReplacementPartTax("AAJ", "Tax on replacement part"),
    GoodsAndServicesTax("GST", "Good and services tax"),
    EnvironmentalTax("ENV", "Environmental tax"),
    ValueAddedTax("VAT", "value added tax"),
    ImportTax("IMP", "Import tax"),
    OtherTaxes("OTH", "Other taxes");

    private String _value;
    private String _displayName;
    private static Map<String, TaxCode> enums;

    private TaxCode(String value, String name) {
        this._value = value;
        this._displayName = name;
    }

    public String getValue() {
        return this._value;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String toString() {
        return this._displayName;
    }

    private TaxCode(String taxCode) {
        this._value = taxCode;
    }

    public static TaxCode codeOf(String taxCode) {
        return enums.get(taxCode);
    }

    static {
        enums = new HashMap<String, TaxCode>();
        for (TaxCode TaxCodeEnum : TaxCode.values()) {
            enums.put(TaxCodeEnum._value, TaxCodeEnum);
        }
    }
}

