/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.settlement;

import java.math.BigDecimal;
import net.dreceiptx.receipt.common.Currency;
import net.dreceiptx.receipt.settlement.PaymentAuthorisation;
import net.dreceiptx.receipt.settlement.PaymentMethodType;

public class PaymentReceipt {
    private int _id;
    private PaymentMethodType _paymentMethodType;
    private BigDecimal _paymentAmount;
    private Currency _settlementCurrency;
    private PaymentAuthorisation _paymentAuthorisation;

    public PaymentReceipt(PaymentMethodType paymentMethodCode, double paymentAmount) {
        this._paymentMethodType = paymentMethodCode;
        this._paymentAmount = BigDecimal.valueOf(paymentAmount);
    }

    public PaymentReceipt(PaymentMethodType paymentMethodCode, BigDecimal paymentAmount) {
        this._paymentMethodType = paymentMethodCode;
        this._paymentAmount = paymentAmount;
    }

    public PaymentReceipt(PaymentMethodType paymentMethodCode, BigDecimal paymentAmount, Currency settlementCurrency) {
        this(paymentMethodCode, paymentAmount);
        this._settlementCurrency = settlementCurrency;
        this._paymentAuthorisation = null;
    }

    public void setId(int id) {
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    public PaymentMethodType getPaymentMethodType() {
        return this._paymentMethodType;
    }

    public void setPaymentMethodType(PaymentMethodType paymentMethodType) {
        this._paymentMethodType = paymentMethodType;
    }

    public BigDecimal getPaymentAmount() {
        return this._paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this._paymentAmount = paymentAmount;
    }

    public Currency getSettlementCurrency() {
        return this._settlementCurrency;
    }

    public void setSettlementCurrency(Currency settlementCurrency) {
        this._settlementCurrency = settlementCurrency;
    }

    public boolean hasPaymentAuthorisation() {
        return this._paymentAuthorisation != null;
    }

    public PaymentAuthorisation getPaymentAuthorisation() {
        return this._paymentAuthorisation;
    }

    public void setPaymentAuthorisation(PaymentAuthorisation paymentAuthorisation) {
        this._paymentAuthorisation = paymentAuthorisation;
    }
}

