/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.serialization.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.dreceiptx.users.NewUser;
import net.dreceiptx.users.UserConfigOptionType;
import net.dreceiptx.users.UserIdentifierType;

public class NewUsersSerializer
implements JsonSerializer<List<NewUser>> {
    public JsonElement serialize(List<NewUser> newUsers, Type type, JsonSerializationContext jsc) {
        JsonObject tree = new JsonObject();
        tree.addProperty("usersToRegister", (Number)newUsers.size());
        JsonArray users = new JsonArray();
        for (NewUser newUser : newUsers) {
            JsonObject userObject = new JsonObject();
            userObject.addProperty("userEmail", newUser.getEmail());
            JsonArray identifiersArray = new JsonArray();
            for (Map.Entry<UserIdentifierType, String> entry : newUser.getIdentifiers().entrySet()) {
                JsonObject userIdentifierObject = new JsonObject();
                userIdentifierObject.addProperty("type", entry.getKey().getValue());
                userIdentifierObject.addProperty("value", entry.getValue());
                identifiersArray.add((JsonElement)userIdentifierObject);
            }
            userObject.add("identifiers", (JsonElement)identifiersArray);
            JsonArray configArray = new JsonArray();
            for (Map.Entry<UserConfigOptionType, String> entry : newUser.getConfig().entrySet()) {
                JsonObject configObject = new JsonObject();
                configObject.addProperty("option", entry.getKey().getValue());
                configObject.addProperty("value", entry.getValue());
                configArray.add((JsonElement)configObject);
            }
            userObject.add("config", (JsonElement)configArray);
            users.add((JsonElement)userObject);
        }
        tree.add("users", (JsonElement)users);
        return tree;
    }
}

