/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.invoice;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.dreceiptx.config.ConfigManager;
import net.dreceiptx.config.Location;
import net.dreceiptx.receipt.allowanceCharge.ReceiptAllowanceCharge;
import net.dreceiptx.receipt.common.DespatchInformation;
import net.dreceiptx.receipt.common.LocationInformation;
import net.dreceiptx.receipt.common.TransactionalParty;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.tax.TaxCode;
import net.dreceiptx.receipt.validation.ReceiptValidation;

public class Invoice {
    @SerializedName(value="documentStatusCode")
    private final String _documentStatusCode = "ORIGINAL";
    @SerializedName(value="invoiceType")
    private final String _invoiceType = "TAX_INVOICE";
    @SerializedName(value="invoiceCurrencyCode")
    private String _invoiceCurrencyCode;
    @SerializedName(value="countryOfSupplyOfGoods")
    private String _countryOfSupplyOfGoods;
    private transient LocationInformation _origin = new LocationInformation();
    private transient LocationInformation _destination = new LocationInformation();
    private transient DespatchInformation _despatchInformation = new DespatchInformation();
    private transient AtomicInteger _lineItemId = null;
    private transient AtomicInteger _allowanceOrChargeId = null;
    private transient Date _creationDateTime = null;
    private transient List<LineItem> _invoiceLineItems = new ArrayList<LineItem>();
    private transient List<ReceiptAllowanceCharge> _allowanceOrCharges = new ArrayList<ReceiptAllowanceCharge>();
    private transient String _invoiceIdentification;
    private transient String _merchantName;
    private transient Map<String, String> _companyTaxNumbers = new HashMap<String, String>();
    private transient String _purchaseOrder;
    private transient String _customerReference;
    private transient String _salesOrderReference = null;
    private transient String _defaultTimeZone;
    private transient String _dateTimeFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
    @SerializedName(value="billTo")
    private TransactionalParty _billTo;

    public Invoice() {
        this._creationDateTime = new Date();
        this._lineItemId = new AtomicInteger(1);
        this._allowanceOrChargeId = new AtomicInteger(1);
    }

    public Invoice(Location location) {
        this();
        this._invoiceCurrencyCode = location.getCurrency().getCode();
        this._countryOfSupplyOfGoods = location.getCountry().getCode();
        this._defaultTimeZone = location.getTimeZone().getDisplayName();
    }

    public Invoice(ConfigManager configManager) {
        this();
        this._invoiceCurrencyCode = configManager.getConfigValue("default.currency");
        this._countryOfSupplyOfGoods = configManager.getConfigValue("default.country");
        this._defaultTimeZone = configManager.getConfigValue("default.timezone");
    }

    public String getMerchantName() {
        return this._merchantName;
    }

    public void setMerchantName(String merchantName) {
        this._merchantName = merchantName;
    }

    public String getCompanyTaxNumber(TaxCode taxCode) {
        return this._companyTaxNumbers.get(taxCode.getValue());
    }

    public void addCompanyTaxNumber(String taxCode, String taxNumber) {
        this._companyTaxNumbers.put(taxCode, taxNumber);
    }

    public void setPurchaseOrder(String purchaseOrder) {
        this._purchaseOrder = purchaseOrder;
    }

    public String getPurchaseOrder() {
        return this._purchaseOrder;
    }

    public void setCustomerReference(String customerReference) {
        this._customerReference = customerReference;
    }

    public String getCustomerReference() {
        return this._customerReference;
    }

    public void setSalesOrderReference(String salesOrderReference) {
        this._salesOrderReference = salesOrderReference;
    }

    public String getSalesOrderReference() {
        return this._salesOrderReference;
    }

    public void setCreationDateTime(Date date) {
        this._creationDateTime = date;
    }

    public Date getCreationDateTime() {
        return this._creationDateTime;
    }

    public String getCreationDateTimeString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this._dateTimeFormat);
        return dateFormat.format(this._creationDateTime);
    }

    public void setInvoiceIdentification(String invoiceIdentification) {
        this._invoiceIdentification = invoiceIdentification;
    }

    public String getInvoiceIdentification() {
        return this._invoiceIdentification;
    }

    public String getInvoiceCurrencyCode() {
        return this._invoiceCurrencyCode;
    }

    public void setInvoiceCurrencyCode(String invoiceCurrencyCode) {
        this._invoiceCurrencyCode = invoiceCurrencyCode;
    }

    public String getCountryOfSupplyOfGoods() {
        return this._countryOfSupplyOfGoods;
    }

    public void setCountryOfSupplyOfGoods(String countryOfSupplyOfGoods) {
        this._countryOfSupplyOfGoods = countryOfSupplyOfGoods;
    }

    public List<LineItem> getInvoiceLineItems() {
        return this._invoiceLineItems;
    }

    public void setInvoiceLineItems(List<LineItem> invoiceLineItems) {
        this._invoiceLineItems = invoiceLineItems;
    }

    public List<ReceiptAllowanceCharge> getAllowanceOrCharges() {
        return this._allowanceOrCharges;
    }

    public void setOriginInformation(LocationInformation originInformation) {
        this._origin = originInformation;
    }

    public LocationInformation getOriginInformation() {
        return this._origin;
    }

    public void setDestinationInformation(LocationInformation destinationInformation) {
        this._destination = destinationInformation;
    }

    public LocationInformation getDestinationInformation() {
        return this._destination;
    }

    public DespatchInformation getDespatchInformation() {
        return this._despatchInformation;
    }

    public void setBillingInformation(String name) {
        this._billTo = new TransactionalParty(name);
    }

    public void setBillingInformation(TransactionalParty billToTransactionalParty) {
        this._billTo = billToTransactionalParty;
    }

    public boolean isBillingInformationSet() {
        return this._billTo != null;
    }

    public String getBillingOrganisationName() {
        if (this._billTo != null) {
            return this._billTo.getOrganisationName();
        }
        return null;
    }

    public void setDespatchInformation(DespatchInformation despatchInformation) {
        this._despatchInformation = despatchInformation;
    }

    public BigDecimal getTotal() {
        BigDecimal receiptTotal = this.getNetTotal();
        receiptTotal = receiptTotal.add(this.getTaxesTotal());
        return receiptTotal;
    }

    public BigDecimal getNetTotal() {
        BigDecimal receiptTotal = this.getSubTotal();
        receiptTotal = receiptTotal.add(this.getSubTotalCharges());
        receiptTotal = receiptTotal.subtract(this.getSubTotalAllowances());
        return receiptTotal;
    }

    public BigDecimal getSubTotal() {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (LineItem lineItem : this._invoiceLineItems) {
            if (lineItem.isReturnOrExchange()) {
                total = total.subtract(lineItem.getSubTotal());
                continue;
            }
            total = total.add(lineItem.getSubTotal());
        }
        return total;
    }

    public BigDecimal getTaxPercentage() {
        BigDecimal subTotal = this.getSubTotal().add(this.getSubTotalAllowances()).add(this.getSubTotalCharges());
        BigDecimal taxPercentage = BigDecimal.valueOf(0L);
        if (!subTotal.equals(BigDecimal.valueOf(0L))) {
            taxPercentage = this.getTaxesTotal().divide(subTotal, 2, 4).multiply(BigDecimal.valueOf(100L));
        }
        return taxPercentage;
    }

    private boolean isNullOrWhiteSpace(String value) {
        return value == null || value.isEmpty();
    }

    public BigDecimal getTaxesTotal() {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (LineItem lineItem : this._invoiceLineItems) {
            total = total.add(lineItem.getTaxesTotal());
        }
        for (ReceiptAllowanceCharge allowanceCharge : this._allowanceOrCharges) {
            total = total.add(allowanceCharge.getTaxesTotal());
        }
        return total;
    }

    public BigDecimal getTaxesTotal(TaxCode taxCode) {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (LineItem lineItem : this._invoiceLineItems) {
            total = total.add(lineItem.getTaxesTotal(taxCode));
        }
        for (ReceiptAllowanceCharge allowanceCharge : this._allowanceOrCharges) {
            total = total.add(allowanceCharge.getTaxesTotal(taxCode));
        }
        return total;
    }

    public BigDecimal getSubTotalCharges() {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (ReceiptAllowanceCharge allowanceCharge : this._allowanceOrCharges) {
            if (!allowanceCharge.isCharge()) continue;
            total = total.add(allowanceCharge.getSubTotal());
        }
        for (LineItem lineItem : this._invoiceLineItems) {
            total = total.add(lineItem.getChargesTotal());
        }
        return total;
    }

    public BigDecimal getSubTotalAllowances() {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (ReceiptAllowanceCharge allowanceCharge : this._allowanceOrCharges) {
            if (!allowanceCharge.isAllowance()) continue;
            total = total.add(allowanceCharge.getSubTotal());
        }
        for (LineItem lineItem : this._invoiceLineItems) {
            total = total.add(lineItem.getAllowancesTotal());
        }
        return total;
    }

    public int addLineItem(LineItem lineItem) {
        lineItem.setLineItemId(this._lineItemId.getAndIncrement());
        this._invoiceLineItems.add(lineItem);
        return lineItem.getLineItemId();
    }

    public void removeLineItem(int lineItemId) {
        LineItem item = null;
        for (LineItem lineItem : this._invoiceLineItems) {
            if (lineItem.getLineItemId() != lineItemId) continue;
            item = lineItem;
            break;
        }
        if (item != null) {
            this._invoiceLineItems.remove(item);
        }
    }

    public boolean addAllowanceOrCharge(ReceiptAllowanceCharge receiptAllowanceCharge) {
        this._allowanceOrCharges.add(receiptAllowanceCharge);
        return true;
    }

    public void removeAllowanceOrChange(int id) {
        ReceiptAllowanceCharge item = null;
        for (ReceiptAllowanceCharge receiptAllowanceCharge : this._allowanceOrCharges) {
            if (receiptAllowanceCharge.getId() != (double)id) continue;
            item = receiptAllowanceCharge;
            break;
        }
        if (item != null) {
            this._allowanceOrCharges.remove(item);
        }
    }

    public ReceiptValidation validate(ReceiptValidation receiptValidation) {
        if (this._invoiceLineItems.size() < 1) {
            receiptValidation.AddError("Digital Receipt must have a least 1 line item.");
        }
        return receiptValidation;
    }
}

