/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import net.dreceiptx.SDK;
import net.dreceiptx.client.ReceiptPostRequest;
import net.dreceiptx.client.exception.ExchangeClientException;
import net.dreceiptx.config.ConfigManager;
import net.dreceiptx.config.Location;
import net.dreceiptx.receipt.allowanceCharge.ReceiptAllowanceCharge;
import net.dreceiptx.receipt.common.Address;
import net.dreceiptx.receipt.common.Contact;
import net.dreceiptx.receipt.common.Country;
import net.dreceiptx.receipt.common.Currency;
import net.dreceiptx.receipt.common.DeliveryInformation;
import net.dreceiptx.receipt.common.GeographicalCoordinates;
import net.dreceiptx.receipt.common.Language;
import net.dreceiptx.receipt.document.ReceiptContact;
import net.dreceiptx.receipt.document.ReceiptContactType;
import net.dreceiptx.receipt.document.StandardBusinessDocumentHeader;
import net.dreceiptx.receipt.invoice.Invoice;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.StandardLineItem;
import net.dreceiptx.receipt.serialization.json.DigitalReceiptSerializer;
import net.dreceiptx.receipt.settlement.PaymentMethodType;
import net.dreceiptx.receipt.settlement.PaymentReceipt;
import net.dreceiptx.receipt.tax.Tax;
import net.dreceiptx.receipt.tax.TaxCategory;
import net.dreceiptx.receipt.tax.TaxCode;
import net.dreceiptx.receipt.validation.ReceiptValidation;
import net.dreceiptx.users.UserIdentifierType;

public class DigitalReceiptBuilder {
    @SerializedName(value="standardBusinessDocumentHeader")
    private StandardBusinessDocumentHeader _standardBusinessDocumentHeader;
    @SerializedName(value="invoice")
    private Invoice _invoice;
    @SerializedName(value="paymentReceipts")
    private List<PaymentReceipt> _paymentReceipts;
    private static final AtomicInteger _paymentReceiptId = new AtomicInteger(1);
    private String _dRxGLN;
    private String _merchantGLN;
    private String _userGUID;
    private Location _location;
    private TaxCategory _defaultTaxCategory = TaxCategory.APPLICABLE;
    private TaxCode _defaultTaxCode = TaxCode.GoodsAndServicesTax;
    private Currency _defaultCurrency = Currency.USDollar;
    private Language _defaultLanguage = Language.English;
    private TimeZone _defaultTimeZone = TimeZone.getTimeZone("GMT");
    private Country _defaultCountry;
    private boolean isDryRunReceipt = false;

    public DigitalReceiptBuilder(Location location) {
        this._location = location;
        this._defaultCountry = location.getCountry();
        this._defaultLanguage = location.getLanguage();
        this._defaultTimeZone = location.getTimeZone();
        this._defaultCurrency = location.getCurrency();
        this._defaultTaxCode = location.getGoodsAndServicesTaxCode();
        this._standardBusinessDocumentHeader = new StandardBusinessDocumentHeader();
        this._standardBusinessDocumentHeader.setdRxGLN(location.getRegion().getGLN());
        this._standardBusinessDocumentHeader.getDocumentIdentification().setTypeVersion(SDK.LATEST_RECEIPT_VERSION);
        this._standardBusinessDocumentHeader.getDocumentIdentification().setCreationDateAndTime(Calendar.getInstance().getTime());
        this._paymentReceipts = new ArrayList<PaymentReceipt>();
        this._invoice = new Invoice(location);
    }

    public DigitalReceiptBuilder(Location location, String merchantGLN) {
        this(location);
        this._standardBusinessDocumentHeader.setMerchantGLN(merchantGLN);
    }

    public DigitalReceiptBuilder(ConfigManager configManager) throws ExchangeClientException {
        this._defaultCountry = Country.codeOf(this.validateConfigOption(configManager, "default.country"));
        this._defaultLanguage = configManager.exists("default.language") ? Language.codeOf(configManager.getConfigValue("default.language")) : this._defaultLanguage;
        this._defaultTimeZone = TimeZone.getTimeZone(this.validateConfigOption(configManager, "default.timezone"));
        this._defaultCurrency = Currency.codeOf(this.validateConfigOption(configManager, "default.currency"));
        this._defaultTaxCategory = Enum.valueOf(TaxCategory.class, this.validateConfigOption(configManager, "default.taxCategory"));
        this._defaultTaxCode = Enum.valueOf(TaxCode.class, this.validateConfigOption(configManager, "default.taxCode"));
        this._standardBusinessDocumentHeader = new StandardBusinessDocumentHeader();
        if (configManager.exists("drx.gln")) {
            this._standardBusinessDocumentHeader.setdRxGLN(configManager.getConfigValue("drx.gln"));
        }
        if (configManager.exists("merchant.gln")) {
            this._standardBusinessDocumentHeader.setMerchantGLN(configManager.getConfigValue("merchant.gln"));
        }
        this._standardBusinessDocumentHeader.getDocumentIdentification().setTypeVersion(configManager.exists("receipt.version") ? configManager.getConfigValue("receipt.version") : SDK.LATEST_RECEIPT_VERSION);
        this._standardBusinessDocumentHeader.getDocumentIdentification().setCreationDateAndTime(Calendar.getInstance().getTime());
        this._paymentReceipts = new ArrayList<PaymentReceipt>();
        this._invoice = new Invoice(configManager);
    }

    public String getdRxGLN() {
        return this._standardBusinessDocumentHeader.getdRxGLN();
    }

    public Location getLocation() {
        return this._location;
    }

    public TaxCategory getDefaultTaxCategory() {
        return this._defaultTaxCategory;
    }

    public TaxCode getDefaultTaxCode() {
        return this._defaultTaxCode;
    }

    public Currency getDefaultCurrency() {
        return this._defaultCurrency;
    }

    public Language getDefaultLanguage() {
        return this._defaultLanguage;
    }

    public TimeZone getDefaultTimeZone() {
        return this._defaultTimeZone;
    }

    public Country getDefaultCountry() {
        return this._defaultCountry;
    }

    public void setDefaultTaxCategory(TaxCategory taxCategory) {
        this._defaultTaxCategory = taxCategory;
    }

    public void setDefaultTaxCode(TaxCode taxCode) {
        this._defaultTaxCode = taxCode;
    }

    public void setDefaultCurrency(Currency currency) {
        this._defaultCurrency = currency;
    }

    public void setDefaultLanguage(Language language) {
        this._defaultLanguage = language;
    }

    public void setDefaultTimeZone(TimeZone timeZone) {
        this._defaultTimeZone = timeZone;
    }

    public void setDefaultCountry(Country country) {
        this._defaultCountry = country;
    }

    public boolean isDryRunReceipt() {
        return this.isDryRunReceipt;
    }

    public DigitalReceiptBuilder setDryRunReceipt(boolean dryRunReceipt) {
        this.isDryRunReceipt = dryRunReceipt;
        return this;
    }

    public DigitalReceiptBuilder setMerchantGLN(String merchantGLN) {
        this._standardBusinessDocumentHeader.setMerchantGLN(merchantGLN);
        return this;
    }

    public String getMerchantGLN() {
        return this._standardBusinessDocumentHeader.getMerchantGLN();
    }

    public DigitalReceiptBuilder setUserGUID(UserIdentifierType userIdentifierType, String userIdentifierValue) throws ExchangeClientException {
        this._userGUID = userIdentifierType.getValue() + ":" + userIdentifierValue;
        this._standardBusinessDocumentHeader.setUserIdentifier(this._userGUID);
        return this;
    }

    public DigitalReceiptBuilder setMerchantReference(String merchantReference) {
        this._standardBusinessDocumentHeader.getDocumentIdentification().setInstanceIdentifier(merchantReference);
        if (this._invoice.getInvoiceIdentification() == null) {
            this._invoice.setInvoiceIdentification(merchantReference);
        }
        return this;
    }

    public DigitalReceiptBuilder setReceiptCurrency(Currency currency) {
        this._defaultCurrency = currency;
        return this;
    }

    public DigitalReceiptBuilder setReceiptLanguage(Language languageCode) {
        this._defaultLanguage = languageCode;
        return this;
    }

    public DigitalReceiptBuilder setReceiptDateTime(Date invoiceDate) {
        this._invoice.setCreationDateTime(invoiceDate);
        return this;
    }

    public DigitalReceiptBuilder setPurchaseOrderNumber(String purchaseOrder) {
        this._invoice.setPurchaseOrder(purchaseOrder);
        return this;
    }

    public DigitalReceiptBuilder setCustomerReferenceNumber(String customerReference) {
        this._invoice.setCustomerReference(customerReference);
        return this;
    }

    public DigitalReceiptBuilder setBillingInformation(String name) {
        this._invoice.setBillingInformation(name);
        return this;
    }

    public DigitalReceiptBuilder setSalesOrderReference(String salesOrderReference) {
        this._invoice.setSalesOrderReference(salesOrderReference);
        return this;
    }

    public DigitalReceiptBuilder addClientRecipientContact(String name, String email, String phone) {
        this.addRMSContact(ReceiptContactType.RECIPIENT_CONTACT, name, email, phone);
        return this;
    }

    public DigitalReceiptBuilder addClientRecipientContact(String name, String email) {
        this.addRMSContact(ReceiptContactType.RECIPIENT_CONTACT, name, email, null);
        return this;
    }

    public DigitalReceiptBuilder addClientRecipientContact(String name) {
        this.addRMSContact(ReceiptContactType.RECIPIENT_CONTACT, name, null, null);
        return this;
    }

    public DigitalReceiptBuilder addClientPurchasingContact(String name, String email, String phone) {
        this.addRMSContact(ReceiptContactType.PURCHASING_CONTACT, name, email, phone);
        return this;
    }

    public DigitalReceiptBuilder addClientPurchasingContact(String name, String email) {
        this.addRMSContact(ReceiptContactType.PURCHASING_CONTACT, name, email, null);
        return this;
    }

    public DigitalReceiptBuilder addClientPurchasingContact(String name) {
        this.addRMSContact(ReceiptContactType.PURCHASING_CONTACT, name, null, null);
        return this;
    }

    private DigitalReceiptBuilder addRMSContact(ReceiptContactType type, String name, String email, String phone) {
        ReceiptContact rmsContact = new ReceiptContact(type, name);
        if (email != null) {
            rmsContact.addEmailAddress(email);
        }
        if (phone != null) {
            rmsContact.addTelephoneNumber(phone);
        }
        this._standardBusinessDocumentHeader.addRMSContact(rmsContact);
        return this;
    }

    public DigitalReceiptBuilder addMerchantCustomerRelationsContact(String name, String email, String phone) {
        this.addMerchantContact(ReceiptContactType.CUSTOMER_RELATIONS, name, email, phone);
        return this;
    }

    public DigitalReceiptBuilder addMerchantCustomerRelationsContact(String name, String email) {
        this.addMerchantContact(ReceiptContactType.CUSTOMER_RELATIONS, name, email, null);
        return this;
    }

    public DigitalReceiptBuilder addMerchantCustomerRelationsContact(String name) {
        this.addMerchantContact(ReceiptContactType.CUSTOMER_RELATIONS, name, null, null);
        return this;
    }

    public DigitalReceiptBuilder addMerchantDeliveryContact(String name, String email, String phone) {
        this.addMerchantContact(ReceiptContactType.DELIVERY_CONTACT, name, email, phone);
        return this;
    }

    public DigitalReceiptBuilder addMerchantDeliveryContact(String name, String email) {
        this.addMerchantContact(ReceiptContactType.DELIVERY_CONTACT, name, email, null);
        return this;
    }

    public DigitalReceiptBuilder addMerchantDeliveryContact(String name) {
        this.addMerchantContact(ReceiptContactType.DELIVERY_CONTACT, name, null, null);
        return this;
    }

    public DigitalReceiptBuilder addMerchantSalesAssistantContact(String name, String email, String phone) {
        this.addMerchantContact(ReceiptContactType.SALES_ADMINISTRATION, name, email, phone);
        return this;
    }

    public DigitalReceiptBuilder addMerchantSalesAssistantContact(String name, String email) {
        this.addMerchantContact(ReceiptContactType.SALES_ADMINISTRATION, name, email, null);
        return this;
    }

    public DigitalReceiptBuilder addMerchantSalesAssistantContact(String name) {
        this.addMerchantContact(ReceiptContactType.SALES_ADMINISTRATION, name, null, null);
        return this;
    }

    private DigitalReceiptBuilder addMerchantContact(ReceiptContactType type, String name, String email, String phone) {
        ReceiptContact merchantContact = new ReceiptContact(type, name);
        if (email != null) {
            merchantContact.addEmailAddress(email);
        }
        if (phone != null) {
            merchantContact.addTelephoneNumber(phone);
        }
        this._standardBusinessDocumentHeader.addMerchantContact(merchantContact);
        return this;
    }

    public DigitalReceiptBuilder setReceiptNumber(String receiptNumber) {
        this._invoice.setInvoiceIdentification(receiptNumber);
        if (this._standardBusinessDocumentHeader.getDocumentIdentification().getInstanceIdentifier() == null) {
            this._standardBusinessDocumentHeader.getDocumentIdentification().setInstanceIdentifier(receiptNumber);
        }
        return this;
    }

    public DigitalReceiptBuilder addLineItem(LineItem lineItem, Tax tax) {
        lineItem.addTax(tax);
        for (Tax lineItemTax : lineItem.getTaxes()) {
            this.configureTax(lineItemTax);
        }
        this._invoice.addLineItem(lineItem);
        return this;
    }

    public DigitalReceiptBuilder addLineItem(LineItem lineItem) {
        for (Tax lineItemTax : lineItem.getTaxes()) {
            this.configureTax(lineItemTax);
        }
        this._invoice.addLineItem(lineItem);
        return this;
    }

    public DigitalReceiptBuilder addLineItem(String brand, String name, int quantity, double price) {
        StandardLineItem lineItem = new StandardLineItem(brand, name, "", quantity, price);
        this._invoice.addLineItem(lineItem);
        return this;
    }

    public DigitalReceiptBuilder addLineItem(String brand, String name, int quantity, double price, Tax tax) {
        StandardLineItem lineItem = new StandardLineItem(brand, name, "", quantity, price);
        lineItem.addTax(this.configureTax(tax));
        this._invoice.addLineItem(lineItem);
        return this;
    }

    public DigitalReceiptBuilder addLineItem(String brand, String name, String description, int quantity, double price) {
        StandardLineItem lineItem = new StandardLineItem(brand, name, description, quantity, price);
        this._invoice.addLineItem(lineItem);
        return this;
    }

    public DigitalReceiptBuilder addLineItem(String brand, String name, String description, int quantity, double price, Tax tax) {
        StandardLineItem lineItem = new StandardLineItem(brand, name, description, quantity, price);
        lineItem.addTax(this.configureTax(tax));
        this._invoice.addLineItem(lineItem);
        return this;
    }

    public DigitalReceiptBuilder addLineItem(String brand, String name, String description, int quantity, double price, double taxRate, boolean taxInclusive) {
        StandardLineItem lineItem;
        if (taxInclusive) {
            BigDecimal netPrice = BigDecimal.valueOf(price).multiply(BigDecimal.valueOf(1L).subtract(BigDecimal.valueOf(taxRate)));
            BigDecimal total = BigDecimal.valueOf(quantity).multiply(netPrice);
            Tax tax = new Tax(this._defaultTaxCategory, this._defaultTaxCode, total.doubleValue(), taxRate);
            lineItem = new StandardLineItem(brand, name, description, quantity, price);
            lineItem.addTax(tax);
        } else {
            BigDecimal netPrice = BigDecimal.valueOf(price);
            BigDecimal total = BigDecimal.valueOf(quantity).multiply(netPrice);
            Tax tax = new Tax(this._defaultTaxCategory, this._defaultTaxCode, total.doubleValue(), taxRate);
            lineItem = new StandardLineItem(brand, name, description, quantity, price);
            lineItem.addTax(tax);
        }
        this._invoice.addLineItem(lineItem);
        return this;
    }

    public DigitalReceiptBuilder addPaymentReceipt(PaymentMethodType paymentMethodCode, Double paymentAmount) {
        PaymentReceipt paymentReceipt = new PaymentReceipt(paymentMethodCode, paymentAmount);
        paymentReceipt.setSettlementCurrency(this._defaultCurrency);
        paymentReceipt.setId(_paymentReceiptId.getAndIncrement());
        this._paymentReceipts.add(paymentReceipt);
        return this;
    }

    public DigitalReceiptBuilder addPaymentReceipt(PaymentReceipt paymentReceipt) {
        paymentReceipt.setId(_paymentReceiptId.getAndIncrement());
        paymentReceipt.setSettlementCurrency(this._defaultCurrency);
        this._paymentReceipts.add(paymentReceipt);
        paymentReceipt.getId();
        return this;
    }

    public DigitalReceiptBuilder addGeneralDiscount(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.GeneralDiscount(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addGeneralDiscount(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.GeneralDiscount(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addTip(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.Tip(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addTip(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.Tip(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addPackagingFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.PackagingFee(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addPackagingFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.PackagingFee(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addDeliveryFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.DeliveryFee(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addDeliveryFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.DeliveryFee(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addFreightFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.FreightFee(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addFreightFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.FreightFee(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addProcessingFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.ProcessingFee(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addProcessingFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.ProcessingFee(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addBookingFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.BookingFee(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addBookingFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.BookingFee(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addAdminFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.AdminFee(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addAdminFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.AdminFee(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addAmendmentFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.AmendmentFee(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addAmendmentFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.AmendmentFee(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addServiceFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.ServiceFee(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addServiceFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.ServiceFee(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder addReturnOrCancellationFee(double amount, String description) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.ReturnOrCancellationFee(amount, description));
        return this;
    }

    public DigitalReceiptBuilder addReturnOrCancellationFee(double amount, String description, Tax tax) {
        this._invoice.addAllowanceOrCharge(ReceiptAllowanceCharge.ReturnOrCancellationFee(amount, description, this.configureTax(tax)));
        return this;
    }

    public DigitalReceiptBuilder setDeliveryInformation(DeliveryInformation deliveryInformation) {
        this._invoice.setDestinationInformation(deliveryInformation.getLocationInformation());
        this._invoice.getAllowanceOrCharges().addAll(deliveryInformation.getDeliveryFees());
        this._invoice.setDespatchInformation(deliveryInformation.getDespatchInformation());
        return this;
    }

    public DigitalReceiptBuilder setDeliveryAddress(Address address) {
        this._invoice.getDestinationInformation().setAddress(address);
        return this;
    }

    public DigitalReceiptBuilder setDeliveryAddress(Address address, Contact contact) {
        this._invoice.getDestinationInformation().setAddress(address);
        this._invoice.getDestinationInformation().addContact(contact);
        return this;
    }

    public DigitalReceiptBuilder setDestinationCoordinates(GeographicalCoordinates geographicalCoordinates) {
        this._invoice.getDestinationInformation().setGeographicalCoordinates(geographicalCoordinates);
        return this;
    }

    public DigitalReceiptBuilder setDeliveryDate(Date deliverDate) {
        this._invoice.getDespatchInformation().setDeliveryDate(deliverDate);
        return this;
    }

    public DigitalReceiptBuilder setOriginAddress(Address address) {
        this._invoice.getOriginInformation().setAddress(address);
        return this;
    }

    public DigitalReceiptBuilder setOriginAddress(Address address, Contact contact) {
        this._invoice.getOriginInformation().setAddress(address);
        this._invoice.getOriginInformation().addContact(contact);
        return this;
    }

    public DigitalReceiptBuilder setOriginCoordinates(GeographicalCoordinates geographicalCoordinates) {
        this._invoice.getOriginInformation().setGeographicalCoordinates(geographicalCoordinates);
        return this;
    }

    public DigitalReceiptBuilder validate() {
        ReceiptValidation receiptValidation = new ReceiptValidation();
        this._standardBusinessDocumentHeader.validate(receiptValidation);
        this._invoice.validate(receiptValidation);
        return this;
    }

    private Tax configureTax(Tax tax) {
        if (tax.getTaxCategory() == null) {
            tax.setTaxCategory(this._defaultTaxCategory);
        }
        if (tax.getTaxCode() == null) {
            tax.setTaxCode(this._defaultTaxCode);
        }
        return tax;
    }

    public BigDecimal getReceiptTotal() {
        return this._invoice.getTotal();
    }

    public BigDecimal getReceiptGSTTotal() {
        return this._invoice.getTaxesTotal(TaxCode.GoodsAndServicesTax);
    }

    public BigDecimal getReceiptTaxTotal() {
        return this._invoice.getTaxesTotal();
    }

    public ReceiptPostRequest buildReceiptPostRequest() {
        DigitalReceiptSerializer digitalReceiptSerializer = new DigitalReceiptSerializer();
        digitalReceiptSerializer.setInvoice(this._invoice);
        digitalReceiptSerializer.setStandardBusinessDocumentHeader(this._standardBusinessDocumentHeader);
        digitalReceiptSerializer.setPaymentReceipts(this._paymentReceipts);
        ReceiptPostRequest receiptPostRequest = new ReceiptPostRequest();
        receiptPostRequest.setDigitalReceiptSerializer(digitalReceiptSerializer);
        receiptPostRequest.setDryRun(this.isDryRunReceipt);
        receiptPostRequest.setCurrency(this._defaultCurrency);
        receiptPostRequest.setLocation(this._location);
        receiptPostRequest.setUserGUID(this._userGUID);
        receiptPostRequest.setdRxGLN(this._dRxGLN);
        return receiptPostRequest;
    }

    public String buildJson() {
        return this.buildReceiptPostRequest().getJsonPayloadContent();
    }

    private String validateConfigOption(ConfigManager configManager, String configParameter) throws ExchangeClientException {
        if (configManager.exists(configParameter)) {
            return configManager.getConfigValue(configParameter);
        }
        throw new ExchangeClientException(101, "Required config parameter " + configParameter + " not supplied");
    }
}

