/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.config;

import java.util.HashMap;
import java.util.Map;

public enum Region {
    Australasia("AUS", "9377778071234", "https://aus-api.dreceiptx.net", "https://directory.dreceiptx.net"),
    AsiaPacificCentral("APC", "9377778071234", "https://apc-api.dreceiptx.net", "https://directory.dreceiptx.net"),
    Canada("CAN", "9377778071234", "https://can-api.dreceiptx.net", "https://directory.dreceiptx.net"),
    EuroEast("EUE", "9377778071234", "https://eue-api.dreceiptx.net", "https://directory.dreceiptx.net"),
    EuroWest("EUW", "9377778071234", "https://euw-api.dreceiptx.net", "https://directory.dreceiptx.net"),
    USEast("USE", "9377778071234", "https://use-api.dreceiptx.net", "https://directory.dreceiptx.net"),
    USWest("USW", "9377778071234", "https://usw-api.dreceiptx.net", "https://directory.dreceiptx.net");

    private String _code;
    private String _gln;
    private String _apiEndpoint;
    private String _directoryEndpoint;
    private static Map<String, Region> enums;

    private Region(String code, String gln, String apiEndpoint, String directoryEndpoint) {
        this._code = code;
        this._gln = gln;
        this._apiEndpoint = apiEndpoint;
        this._directoryEndpoint = directoryEndpoint;
    }

    public String getCode() {
        return this._code;
    }

    public String getGLN() {
        return this._gln;
    }

    public String getAPIEndpoint() {
        return this._apiEndpoint;
    }

    public String getDirectoryEndpoint() {
        return this._directoryEndpoint;
    }

    public String toString() {
        return this._code;
    }

    private Region(String code) {
        this._code = code;
    }

    public static Region codeOf(String code) {
        return enums.get(code);
    }

    static {
        enums = new HashMap<String, Region>();
        for (Region region : Region.values()) {
            enums.put(region._code, region);
        }
    }
}

